/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNCancellableOutputStream
extends FilterOutputStream {
    private ISVNCanceller myEventHandler;

    public SVNCancellableOutputStream(OutputStream out, ISVNCanceller eventHandler) {
        super(out == null ? SVNFileUtil.DUMMY_OUT : out);
        this.myEventHandler = eventHandler;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.myEventHandler != null) {
            try {
                this.myEventHandler.checkCancelled();
            }
            catch (SVNCancelException e) {
                throw new IOCancelException(e.getMessage());
            }
        }
        this.out.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.myEventHandler != null) {
            try {
                this.myEventHandler.checkCancelled();
            }
            catch (SVNCancelException e) {
                throw new IOCancelException(e.getMessage());
            }
        }
        this.out.write(b);
    }

    public static class IOCancelException
    extends IOException {
        private static final long serialVersionUID = 4845L;

        public IOCancelException(String message) {
            super(message);
        }
    }
}

