/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnNgMergeinfoUtil {
    private static Map<String, SVNMergeRangeList> parseMergeInfo(SVNWCContext context, File localAbsPath) throws SVNException {
        SVNPropertyValue propValue = context.getPropertyValue(localAbsPath, "svn:mergeinfo");
        if (propValue != null && propValue.getString() != null) {
            return SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(propValue.getString()), null);
        }
        return null;
    }

    public static void elideMergeInfo(SVNWCContext context, SVNRepository repos, File targetAbsPath, File limitAbsPath) throws SVNException {
        if (limitAbsPath == null || !limitAbsPath.equals(targetAbsPath)) {
            SvnMergeInfoInfo targetMergeinfo = null;
            try {
                targetMergeinfo = SvnNgMergeinfoUtil.getWCMergeInfo(context, targetAbsPath, limitAbsPath, SVNMergeInfoInheritance.INHERITED, false);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.MERGE_INFO_PARSE_ERROR) {
                    throw e;
                }
                return;
            }
            if (targetMergeinfo == null || targetMergeinfo.inherited || targetMergeinfo.mergeinfo == null) {
                return;
            }
            SvnMergeInfoInfo mergeinfo = null;
            try {
                mergeinfo = SvnNgMergeinfoUtil.getWCMergeInfo(context, targetAbsPath, limitAbsPath, SVNMergeInfoInheritance.NEAREST_ANCESTOR, false);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.MERGE_INFO_PARSE_ERROR) {
                    throw e;
                }
                return;
            }
            if ((mergeinfo == null || mergeinfo.mergeinfo == null) && limitAbsPath == null) {
                mergeinfo = new SvnMergeInfoInfo();
                try {
                    mergeinfo.mergeinfo = SvnNgMergeinfoUtil.getWCOrReposMergeInfo(context, targetAbsPath, repos, true, SVNMergeInfoInheritance.NEAREST_ANCESTOR);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.MERGE_INFO_PARSE_ERROR) {
                        throw e;
                    }
                    return;
                }
            }
            if (mergeinfo.mergeinfo == null && limitAbsPath != null) {
                return;
            }
            SvnNgMergeinfoUtil.elideMergeInfo(context, mergeinfo.mergeinfo, targetMergeinfo.mergeinfo, targetAbsPath);
        }
    }

    private static void elideMergeInfo(SVNWCContext context, Map<String, SVNMergeRangeList> parent, Map<String, SVNMergeRangeList> child, File targetAbsPath) throws SVNException {
        if (SVNMergeInfoUtil.shouldElideMergeInfo(parent, child, null)) {
            SvnNgPropertiesManager.setProperty(context, targetAbsPath, "svn:mergeinfo", null, SVNDepth.EMPTY, true, null, null);
            if (context.getEventHandler() != null) {
                SVNEvent event = SVNEventFactory.createSVNEvent(targetAbsPath, SVNNodeKind.UNKNOWN, null, -1L, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.MERGE_ELIDE_INFO, null, null, null, null);
                context.getEventHandler().handleEvent(event, -1.0);
                event = SVNEventFactory.createSVNEvent(targetAbsPath, SVNNodeKind.UNKNOWN, null, -1L, SVNStatusType.INAPPLICABLE, SVNStatusType.CHANGED, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.UPDATE_UPDATE, null, null, null, null);
                context.getEventHandler().handleEvent(event, -1.0);
            }
        }
    }

    public static SvnMergeInfoInfo getWCMergeInfo(SVNWCContext context, File localAbsPath, File limitAbsPath, SVNMergeInfoInheritance inheritance, boolean ignoreInvalidMergeInfo) throws SVNException {
        long parentBaseRev;
        long parentChangedRev;
        long baseRevision = context.getNodeBaseRev(localAbsPath);
        Map<String, SVNMergeRangeList> wcMergeInfo = null;
        String walkRelPath = "";
        SvnMergeInfoInfo result = new SvnMergeInfoInfo();
        do {
            if (inheritance == SVNMergeInfoInheritance.NEAREST_ANCESTOR) {
                wcMergeInfo = null;
                inheritance = SVNMergeInfoInheritance.INHERITED;
            } else {
                try {
                    wcMergeInfo = SvnNgMergeinfoUtil.parseMergeInfo(context, localAbsPath);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.MERGE_INFO_PARSE_ERROR && (ignoreInvalidMergeInfo || !"".equals(walkRelPath))) {
                        wcMergeInfo = new HashMap<String, SVNMergeRangeList>();
                        break;
                    }
                    throw e;
                }
            }
            if (wcMergeInfo != null || inheritance == SVNMergeInfoInheritance.EXPLICIT || SVNFileUtil.getParentFile(localAbsPath) == null || limitAbsPath != null && localAbsPath.equals(limitAbsPath)) break;
            SVNWCContext.CheckWCRootInfo rootInfo = context.checkWCRoot(localAbsPath, true);
            if (rootInfo.wcRoot || rootInfo.switched) break;
            walkRelPath = SVNPathUtil.append(SVNFileUtil.getFileName(localAbsPath), walkRelPath);
            localAbsPath = SVNFileUtil.getFileDir(localAbsPath);
            parentBaseRev = context.getNodeBaseRev(localAbsPath);
            parentChangedRev = context.getNodeChangedInfo((File)localAbsPath).changedRev;
        } while (baseRevision < 0L || baseRevision >= parentChangedRev && parentBaseRev >= baseRevision);
        if ("".equals(walkRelPath)) {
            result.inherited = false;
            result.mergeinfo = wcMergeInfo;
        } else if (wcMergeInfo != null) {
            result.inherited = true;
            result.mergeinfo = new HashMap<String, SVNMergeRangeList>();
            result.mergeinfo = SVNMergeInfoUtil.adjustMergeInfoSourcePaths(result.mergeinfo, walkRelPath, wcMergeInfo);
        } else {
            result.inherited = false;
            result.mergeinfo = null;
        }
        result.walkRelPath = walkRelPath;
        if (result.inherited && !result.mergeinfo.isEmpty()) {
            result.mergeinfo = SVNMergeInfoUtil.getInheritableMergeInfo(result.mergeinfo, null, -1L, -1L);
            SVNMergeInfoUtil.removeEmptyRangeLists(result.mergeinfo);
        }
        return result;
    }

    private static SvnMergeInfoCatalogInfo getWcMergeInfoCatalog(SVNWCContext context, boolean includeDescendants, SVNMergeInfoInheritance inheritance, File localAbsPath, File limitAbsPath, boolean ignoreInvalidMergeInfo) throws SVNException {
        SvnMergeInfoCatalogInfo result = new SvnMergeInfoCatalogInfo();
        SVNWCContext.SVNWCNodeReposInfo reposInfo = context.getNodeReposInfo(localAbsPath);
        if (reposInfo.reposRootUrl == null) {
            result.walkRelPath = "";
            return result;
        }
        File targetReposRelPath = context.getNodeReposRelPath(localAbsPath);
        SvnMergeInfoInfo mi = SvnNgMergeinfoUtil.getWCMergeInfo(context, localAbsPath, limitAbsPath, inheritance, ignoreInvalidMergeInfo);
        result.walkRelPath = mi.walkRelPath;
        result.inherited = mi.inherited;
        if (mi.mergeinfo != null) {
            result.catalog = new TreeMap<String, Map<String, SVNMergeRangeList>>();
            result.catalog.put(SVNFileUtil.getFilePath(targetReposRelPath), mi.mergeinfo);
        }
        if (context.readKind(localAbsPath, false) == SVNNodeKind.DIR && includeDescendants) {
            final TreeMap mergeInfoProperties = new TreeMap();
            ((SVNWCDb)context.getDb()).readPropertiesRecursively(localAbsPath, SVNDepth.INFINITY, false, false, null, new ISvnObjectReceiver<SVNProperties>(){

                @Override
                public void receive(SvnTarget target, SVNProperties object) throws SVNException {
                    if (object.getStringValue("svn:mergeinfo") != null) {
                        mergeInfoProperties.put(target.getFile(), object.getStringValue("svn:mergeinfo"));
                    }
                }
            });
            for (File childPath : mergeInfoProperties.keySet()) {
                String propValue = (String)mergeInfoProperties.get(childPath);
                File keyPath = context.getNodeReposRelPath(childPath);
                Map<String, SVNMergeRangeList> childMergeInfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(propValue), null);
                if (result.catalog == null) {
                    result.catalog = new TreeMap<String, Map<String, SVNMergeRangeList>>();
                }
                result.catalog.put(SVNFileUtil.getFilePath(keyPath), childMergeInfo);
            }
        }
        return result;
    }

    private static SvnMergeInfoCatalogInfo getReposMergeInfoCatalog(SVNRepository repository, String relativePath, long revision, SVNMergeInfoInheritance inheritance, boolean squelchIncapable, boolean includeDescendats) throws SVNException {
        SvnMergeInfoCatalogInfo result = new SvnMergeInfoCatalogInfo();
        Map<String, SVNMergeInfo> reposMeregInfo = null;
        try {
            reposMeregInfo = repository.getMergeInfo(new String[]{relativePath}, revision, inheritance, includeDescendats);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE && squelchIncapable) {
                return result;
            }
            throw e;
        }
        if (reposMeregInfo != null && !reposMeregInfo.isEmpty()) {
            result.catalog = new TreeMap<String, Map<String, SVNMergeRangeList>>();
            for (String reposRelativePath : reposMeregInfo.keySet()) {
                SVNMergeInfo mi = reposMeregInfo.get(reposRelativePath);
                if (reposRelativePath.startsWith("/")) {
                    reposRelativePath = reposRelativePath.substring(1);
                }
                result.catalog.put(reposRelativePath, mi.getMergeSourcesToMergeLists());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SvnMergeInfoCatalogInfo getWcOrReposMergeInfoCatalog(SVNWCContext context, SVNRepository repository, File wcPath, boolean includeDescendants, boolean reposOnly, boolean ignoreInvalidMergeInfo, SVNMergeInfoInheritance inheritance) throws SVNException {
        SVNProperties originalProperties;
        SvnMergeInfoCatalogInfo result = new SvnMergeInfoCatalogInfo();
        Structure<StructureFields.NodeOriginInfo> nodeOriginInfo = context.getNodeOrigin(wcPath, false, StructureFields.NodeOriginInfo.revision, StructureFields.NodeOriginInfo.reposRelpath, StructureFields.NodeOriginInfo.reposRootUrl);
        SVNURL url = null;
        if (nodeOriginInfo.get(StructureFields.NodeOriginInfo.reposRelpath) != null) {
            url = (SVNURL)nodeOriginInfo.get(StructureFields.NodeOriginInfo.reposRootUrl);
            url = SVNWCUtils.join(url, (File)nodeOriginInfo.get(StructureFields.NodeOriginInfo.reposRelpath));
        }
        long revision = nodeOriginInfo.lng(StructureFields.NodeOriginInfo.revision);
        File reposRelPath = (File)nodeOriginInfo.get(StructureFields.NodeOriginInfo.reposRelpath);
        nodeOriginInfo.release();
        Map<String, Map<String, SVNMergeRangeList>> wcMergeInfoCatalog = null;
        Map<String, Map<String, SVNMergeRangeList>> reposMergeInfoCatalog = null;
        if (!reposOnly) {
            SvnMergeInfoCatalogInfo catalogInfo = SvnNgMergeinfoUtil.getWcMergeInfoCatalog(context, includeDescendants, inheritance, wcPath, null, ignoreInvalidMergeInfo);
            result.inherited = catalogInfo.inherited;
            wcMergeInfoCatalog = catalogInfo.catalog;
            if (!(catalogInfo.inherited || inheritance == SVNMergeInfoInheritance.EXPLICIT || reposRelPath != null && wcMergeInfoCatalog != null && wcMergeInfoCatalog.get(SVNFileUtil.getFilePath(reposRelPath)) != null)) {
                reposOnly = true;
                includeDescendants = false;
            }
        }
        if (reposOnly && url != null && !(originalProperties = context.getPristineProps(wcPath)).containsName("svn:mergeinfo")) {
            SVNURL oldLocation = repository.getLocation();
            try {
                repository.setLocation(url, false);
                SvnMergeInfoCatalogInfo catalogInfo = SvnNgMergeinfoUtil.getReposMergeInfoCatalog(repository, "", revision, inheritance, true, includeDescendants);
                reposMergeInfoCatalog = catalogInfo.catalog;
                if (reposMergeInfoCatalog != null && reposMergeInfoCatalog.containsKey(SVNFileUtil.getFilePath(reposRelPath))) {
                    result.inherited = true;
                }
            }
            finally {
                repository.setLocation(oldLocation, false);
            }
        }
        if (wcMergeInfoCatalog != null) {
            result.catalog = wcMergeInfoCatalog;
            if (reposMergeInfoCatalog != null) {
                SVNMergeInfoUtil.mergeCatalog(result.catalog, reposMergeInfoCatalog);
            }
        } else if (reposMergeInfoCatalog != null) {
            result.catalog = reposMergeInfoCatalog;
        }
        return result;
    }

    public static Map<String, Map<String, SVNMergeRangeList>> getMergeInfo(SVNWCContext context, SvnRepositoryAccess repoAccess, SvnTarget target, boolean includeDescendants, boolean ignoreInvalidMergeInfo, SVNURL[] root) throws SVNException {
        Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = repoAccess.createRepositoryFor(target, SVNRevision.UNDEFINED, target.getPegRevision(), null);
        SVNURL url = (SVNURL)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.url);
        long pegRev = repositoryInfo.lng(SvnRepositoryAccess.RepositoryInfo.revision);
        long rev = -1L;
        SVNRepository repository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
        repositoryInfo.release();
        boolean useURL = target.isURL();
        if (!useURL) {
            SVNURL originURL = null;
            Structure<StructureFields.NodeOriginInfo> nodeOriginInfo = context.getNodeOrigin(target.getFile(), false, StructureFields.NodeOriginInfo.revision, StructureFields.NodeOriginInfo.reposRelpath, StructureFields.NodeOriginInfo.reposRootUrl);
            File reposRelPath = (File)nodeOriginInfo.get(StructureFields.NodeOriginInfo.reposRelpath);
            if (reposRelPath != null) {
                originURL = (SVNURL)nodeOriginInfo.get(StructureFields.NodeOriginInfo.reposRootUrl);
                originURL = SVNWCUtils.join(originURL, reposRelPath);
            }
            rev = nodeOriginInfo.lng(StructureFields.NodeOriginInfo.revision);
            if (originURL == null || !originURL.equals(url) || pegRev != rev) {
                useURL = true;
            }
            nodeOriginInfo.release();
        }
        if (root != null && root.length > 0) {
            root[0] = repository.getRepositoryRoot(true);
        }
        if (useURL) {
            rev = pegRev;
            return SvnNgMergeinfoUtil.getReposMergeInfoCatalog((SVNRepository)repository, (String)"", (long)rev, (SVNMergeInfoInheritance)SVNMergeInfoInheritance.INHERITED, (boolean)false, (boolean)includeDescendants).catalog;
        }
        return SvnNgMergeinfoUtil.getWcOrReposMergeInfoCatalog((SVNWCContext)context, (SVNRepository)repository, (File)target.getFile(), (boolean)includeDescendants, (boolean)false, (boolean)ignoreInvalidMergeInfo, (SVNMergeInfoInheritance)SVNMergeInfoInheritance.INHERITED).catalog;
    }

    public static Map<String, SVNMergeRangeList> getWCOrReposMergeInfo(SVNWCContext context, File wcPath, SVNRepository repository, boolean reposOnly, SVNMergeInfoInheritance inheritance) throws SVNException {
        SvnMergeInfoCatalogInfo catalog = SvnNgMergeinfoUtil.getWcOrReposMergeInfoCatalog(context, repository, wcPath, false, reposOnly, false, inheritance);
        if (catalog != null && catalog.catalog != null) {
            return catalog.catalog.values().iterator().next();
        }
        return null;
    }

    public static Map<String, Map<String, SVNMergeRangeList>> convertToCatalog(Map<String, SVNMergeInfo> catalog) {
        if (catalog == null) {
            return new TreeMap<String, Map<String, SVNMergeRangeList>>();
        }
        TreeMap<String, Map<String, SVNMergeRangeList>> result = new TreeMap<String, Map<String, SVNMergeRangeList>>();
        for (String path : catalog.keySet()) {
            SVNMergeInfo mi = catalog.get(path);
            result.put(path, mi.getMergeSourcesToMergeLists());
        }
        return result;
    }

    public static Map<File, Map<String, SVNMergeRangeList>> convertToCatalog2(Map<String, SVNMergeInfo> catalog) {
        if (catalog == null) {
            return new TreeMap<File, Map<String, SVNMergeRangeList>>();
        }
        TreeMap<File, Map<String, SVNMergeRangeList>> result = new TreeMap<File, Map<String, SVNMergeRangeList>>();
        for (String path : catalog.keySet()) {
            SVNMergeInfo mi = catalog.get(path);
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            result.put(new File(path.replace(File.separatorChar, '/')), mi.getMergeSourcesToMergeLists());
        }
        return result;
    }

    public static Map<String, Map<String, SVNMergeRangeList>> addPrefixToCatalog(Map<String, Map<String, SVNMergeRangeList>> catalog, File prefix) {
        TreeMap<String, Map<String, SVNMergeRangeList>> result = new TreeMap<String, Map<String, SVNMergeRangeList>>();
        for (String path : catalog.keySet()) {
            Map<String, SVNMergeRangeList> mi = catalog.get(path);
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            String prefixedPath = SVNFileUtil.getFilePath(SVNFileUtil.createFilePath(prefix, path));
            result.put(prefixedPath, mi);
        }
        return result;
    }

    public static class SvnMergeInfoCatalogInfo {
        Map<String, Map<String, SVNMergeRangeList>> catalog;
        boolean inherited;
        String walkRelPath;
    }

    public static class SvnMergeInfoInfo {
        Map<String, SVNMergeRangeList> mergeinfo;
        boolean inherited;
        String walkRelPath;
    }
}

