/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc16.SVNMoveClient16;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnCopy;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SVNMoveClient
extends SVNBasicClient {
    public SVNMoveClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNMoveClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public SVNMoveClient(SvnOperationFactory of) {
        super(of);
    }

    public void doMove(File src, File dst) throws SVNException {
        block4: {
            SvnWcGeneration srcGeneration = SvnOperationFactory.detectWcGeneration(src, true, false);
            SvnWcGeneration dstGeneration = SvnOperationFactory.detectWcGeneration(dst, true, true);
            if (srcGeneration == SvnWcGeneration.V17 && dstGeneration == SvnWcGeneration.V17) {
                SvnCopy copy = this.getOperationsFactory().createCopy();
                copy.setMove(true);
                copy.setSingleTarget(SvnTarget.fromFile(dst));
                copy.addCopySource(SvnCopySource.create(SvnTarget.fromFile(src), SVNRevision.WORKING));
                copy.setFailWhenDstExists(true);
                copy.run();
            } else {
                try {
                    SVNMoveClient16 oldClient = new SVNMoveClient16(this.getOperationsFactory().getAuthenticationManager(), this.getOptions());
                    oldClient.doMove(src, dst);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_UNSUPPORTED_FORMAT) break block4;
                    SvnCopy cp = this.getOperationsFactory().createCopy();
                    cp.setMove(true);
                    cp.setSingleTarget(SvnTarget.fromFile(dst));
                    cp.addCopySource(SvnCopySource.create(SvnTarget.fromFile(src), SVNRevision.WORKING));
                    cp.setFailWhenDstExists(true);
                    cp.run();
                }
            }
        }
    }

    public void undoMove(File src, File dst) throws SVNException {
        SVNMoveClient16 oldClient = new SVNMoveClient16(this.getOperationsFactory().getAuthenticationManager(), this.getOptions());
        oldClient.undoMove(src, dst);
    }

    public void doVirtualCopy(File src, File dst, boolean move) throws SVNException {
        SvnCopy copy = this.getOperationsFactory().createCopy();
        copy.addCopySource(SvnCopySource.create(SvnTarget.fromFile(src), SVNRevision.WORKING));
        copy.setSingleTarget(SvnTarget.fromFile(dst));
        copy.setMove(move);
        copy.setVirtual(true);
        copy.run();
    }
}

