/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util.jna;

import com.sun.jna.Pointer;
import java.util.logging.Level;
import org.tmatesoft.svn.core.internal.util.jna.ISVNCLibrary;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class DebugProxyISVNCLibrary
implements ISVNCLibrary {
    private final ISVNCLibrary myLibrary;
    private ISVNDebugLog myDebugLog;

    public DebugProxyISVNCLibrary(ISVNCLibrary library, ISVNDebugLog debugLog) {
        this.myLibrary = library;
        this.myDebugLog = debugLog;
    }

    @Override
    public int chmod(String filename, int mode) {
        int chmod = this.myLibrary.chmod(filename, mode);
        this.myDebugLog.log(SVNLogType.NATIVE_CALL, "CALLED ISVNCLibrary#chmod(" + filename + ", " + mode + ") = " + chmod, Level.INFO);
        return chmod;
    }

    public static String toStringNullable(Object o) {
        return o == null ? "null" : o.toString();
    }

    public static String isNull(Object o) {
        return o == null ? "null" : "NOT null";
    }

    @Override
    public int readlink(String filename, Pointer linkname, int linkNameSize) {
        int readlink = this.myLibrary.readlink(filename, linkname, linkNameSize);
        this.myDebugLog.log(SVNLogType.NATIVE_CALL, "CALLED ISVNCLibrary#readlink(" + filename + ", " + DebugProxyISVNCLibrary.toStringNullable(linkname) + ", " + linkNameSize + ") = " + readlink, Level.INFO);
        return readlink;
    }

    @Override
    public int __lxstat(int ver, String path, Pointer stat) {
        int i = this.myLibrary.__lxstat(ver, path, stat);
        this.myDebugLog.log(SVNLogType.NATIVE_CALL, "CALLED ISVNCLibrary#__lxstat(" + ver + ", " + path + ", " + DebugProxyISVNCLibrary.toStringNullable(stat) + ") = " + i, Level.INFO);
        return i;
    }

    @Override
    public int __lxstat64(int ver, String path, Pointer stat) {
        int i = this.myLibrary.__lxstat64(ver, path, stat);
        this.myDebugLog.log(SVNLogType.NATIVE_CALL, "CALLED ISVNCLibrary#__lxstat64(" + ver + ", " + path + ", " + DebugProxyISVNCLibrary.toStringNullable(stat) + ") = " + i, Level.INFO);
        return i;
    }

    @Override
    public int lstat(String path, Pointer stat) {
        int lstat = this.myLibrary.lstat(path, stat);
        this.myDebugLog.log(SVNLogType.NATIVE_CALL, "CALLED ISVNCLibrary#lstat(" + path + ", " + DebugProxyISVNCLibrary.toStringNullable(stat) + ") = " + lstat, Level.INFO);
        return lstat;
    }

    @Override
    public int _lstat(String path, Pointer stat) {
        int i = this.myLibrary._lstat(path, stat);
        this.myDebugLog.log(SVNLogType.NATIVE_CALL, "CALLED ISVNCLibrary#_lstat(" + path + ", " + DebugProxyISVNCLibrary.toStringNullable(stat) + ") = " + i, Level.INFO);
        return i;
    }

    @Override
    public int __xstat64(int ver, String path, Pointer stat) {
        int i = this.myLibrary.__xstat64(ver, path, stat);
        this.myDebugLog.log(SVNLogType.NATIVE_CALL, "CALLED ISVNCLibrary#__xstat64(" + ver + ", " + path + ", " + DebugProxyISVNCLibrary.toStringNullable(stat) + ") = " + i, Level.INFO);
        return i;
    }

    @Override
    public int _stat(String path, Pointer stat) {
        int i = this.myLibrary._stat(path, stat);
        this.myDebugLog.log(SVNLogType.NATIVE_CALL, "CALLED ISVNCLibrary#_stat(" + path + ", " + DebugProxyISVNCLibrary.toStringNullable(stat) + ") = " + i, Level.INFO);
        return i;
    }

    @Override
    public int stat(String path, Pointer stat) {
        int stat1 = this.myLibrary.stat(path, stat);
        this.myDebugLog.log(SVNLogType.NATIVE_CALL, "CALLED ISVNCLibrary#stat(" + path + ", " + DebugProxyISVNCLibrary.toStringNullable(stat) + ") = " + stat1, Level.INFO);
        return stat1;
    }

    @Override
    public int symlink(String targetPath, String linkPath) {
        int symlink = this.myLibrary.symlink(targetPath, linkPath);
        this.myDebugLog.log(SVNLogType.NATIVE_CALL, "CALLED ISVNCLibrary#symlink(" + targetPath + ", " + linkPath + ") = " + symlink, Level.INFO);
        return symlink;
    }

    @Override
    public int getuid() {
        int getuid = this.myLibrary.getuid();
        this.myDebugLog.log(SVNLogType.NATIVE_CALL, "CALLED ISVNCLibrary#getuid() = " + getuid, Level.INFO);
        return getuid;
    }

    @Override
    public int getgid() {
        int getgid = this.myLibrary.getgid();
        this.myDebugLog.log(SVNLogType.NATIVE_CALL, "CALLED ISVNCLibrary#getgid() = " + getgid, Level.INFO);
        return getgid;
    }
}

