/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.patch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchFileStream;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnDiffHunk;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPatchFile;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPropertiesPatch;

public class SvnPatch {
    private static final Transition[] TRANSITIONS = new Transition[]{new Transition("--- ", ParserState.START, IParserFunction.DIFF_MINUS), new Transition("+++ ", ParserState.MINUS_SEEN, IParserFunction.DIFF_PLUS), new Transition("diff --git", ParserState.START, IParserFunction.GIT_START), new Transition("--- a/", ParserState.GIT_DIFF_SEEN, IParserFunction.GIT_MINUS), new Transition("--- a/", ParserState.GIT_TREE_SEEN, IParserFunction.GIT_MINUS), new Transition("--- /dev/null", ParserState.GIT_TREE_SEEN, IParserFunction.GIT_MINUS), new Transition("+++ b/", ParserState.GIT_MINUS_SEEN, IParserFunction.GIT_PLUS), new Transition("+++ /dev/null", ParserState.GIT_MINUS_SEEN, IParserFunction.GIT_PLUS), new Transition("rename from ", ParserState.GIT_DIFF_SEEN, IParserFunction.GIT_MOVE_FROM), new Transition("rename to ", ParserState.MOVE_FROM_SEEN, IParserFunction.GIT_MOVE_TO), new Transition("copy from ", ParserState.GIT_DIFF_SEEN, IParserFunction.GIT_COPY_FROM), new Transition("copy to ", ParserState.COPY_FROM_SEEN, IParserFunction.GIT_COPY_TO), new Transition("new file ", ParserState.GIT_DIFF_SEEN, IParserFunction.GIT_NEW_FILE), new Transition("deleted file ", ParserState.GIT_DIFF_SEEN, IParserFunction.GIT_DELETED_FILE)};
    private List<SvnDiffHunk> hunks;
    private Map<String, SvnPropertiesPatch> propPatches;
    private SvnDiffCallback.OperationKind operation;
    private boolean reverse;
    Map<String, SVNMergeRangeList> mergeInfo;
    private Map reverseMergeInfo;
    private File oldFileName;
    private File newFileName;
    private File path;
    private SVNPatchFileStream patchFileStream;

    public static SvnPatch parseNextPatch(SvnPatchFile patchFile, boolean reverse, boolean ignoreWhitespace) throws IOException, SVNException {
        boolean eof;
        if (patchFile.getPatchFileStream().isEOF()) {
            return null;
        }
        ParserState state = ParserState.START;
        boolean lineAfterTreeHeaderRead = false;
        SvnPatch patch = new SvnPatch();
        long pos = patchFile.getNextPatchOffset();
        patchFile.getPatchFileStream().setSeekPosition(pos);
        do {
            boolean validHeaderLine = false;
            long lastLine = pos;
            StringBuffer lineBuffer = new StringBuffer();
            eof = patchFile.getPatchFileStream().readLine(lineBuffer);
            String line = lineBuffer.toString();
            if (!eof) {
                pos = patchFile.getPatchFileStream().getSeekPosition();
            }
            for (int i = 0; i < TRANSITIONS.length; ++i) {
                Transition transition = TRANSITIONS[i];
                if (!transition.matches(line, state)) continue;
                state = transition.getParserFunction().parse(line, patch);
                validHeaderLine = true;
                break;
            }
            if (state == ParserState.UNIDIFF_FOUND || state == ParserState.GIT_HEADER_FOUND) break;
            if (state == ParserState.GIT_TREE_SEEN && lineAfterTreeHeaderRead) {
                if (line.startsWith("index ")) continue;
                patchFile.getPatchFileStream().setSeekPosition(lastLine);
                break;
            }
            if (state == ParserState.GIT_TREE_SEEN) {
                lineAfterTreeHeaderRead = true;
                continue;
            }
            if (validHeaderLine || state == ParserState.START || state == ParserState.GIT_DIFF_SEEN || line.startsWith("index ")) continue;
            patchFile.getPatchFileStream().setSeekPosition(lastLine);
            state = ParserState.START;
        } while (!eof);
        patch.setReverse(reverse);
        if (reverse) {
            File tmp = patch.getOldFileName();
            patch.setOldFileName(patch.getNewFileName());
            patch.setNewFileName(tmp);
        }
        if (patch.getOldFileName() == null || patch.getNewFileName() == null) {
            patch = null;
        } else {
            patch.parseHunks(patchFile.getPatchFileStream(), ignoreWhitespace);
        }
        patchFile.setNextPatchOffset(0L);
        patchFile.setNextPatchOffset(patchFile.getPatchFileStream().getSeekPosition());
        if (patch != null) {
            Collections.sort(patch.hunks);
        }
        return patch;
    }

    private void parseHunks(SVNPatchFileStream patchFileStream, boolean ignoreWhitespace) throws IOException, SVNException {
        SvnDiffHunk hunk;
        String lastPropName = null;
        this.hunks = new ArrayList<SvnDiffHunk>();
        this.propPatches = new HashMap<String, SvnPropertiesPatch>();
        do {
            SvnDiffCallback.OperationKind[] propOperation;
            String[] propName;
            boolean[] isProperty;
            if ((hunk = this.parseNextHunk(isProperty = new boolean[1], propName = new String[1], propOperation = new SvnDiffCallback.OperationKind[1], patchFileStream, ignoreWhitespace)) != null && isProperty[0]) {
                if (propName[0] == null) {
                    propName[0] = lastPropName;
                } else {
                    lastPropName = propName[0];
                }
                if ("svn:mergeinfo".equals(propName[0])) continue;
                this.addPropertyHunk(propName[0], hunk, propOperation[0]);
                continue;
            }
            if (hunk == null) continue;
            this.hunks.add(hunk);
            lastPropName = null;
        } while (hunk != null);
    }

    public SvnDiffHunk parseNextHunk(boolean[] isProperty, String[] propName, SvnDiffCallback.OperationKind[] propOperation, SVNPatchFileStream patchStream, boolean ignoreWhitespace) throws IOException, SVNException {
        long lastLine;
        String line;
        boolean eof;
        String minus = "--- ";
        String textAtat = "@@";
        String propAtat = "##";
        propOperation[0] = SvnDiffCallback.OperationKind.Unchanged;
        propName[0] = null;
        isProperty[0] = false;
        if (patchStream.isEOF()) {
            return null;
        }
        boolean inHunk = false;
        boolean hunkSeen = false;
        int leadingContext = 0;
        int trailingContext = 0;
        boolean changedLineSeen = false;
        long originalEnd = 0L;
        long modifiedEnd = 0L;
        long start = 0L;
        long end = 0L;
        int originalLines = 0;
        int modifiedLines = 0;
        SvnDiffHunk hunk = new SvnDiffHunk();
        long pos = patchStream.getSeekPosition();
        LineType lastLineType = LineType.NOISE_LINE;
        do {
            boolean foundMergeInfo;
            lastLine = pos;
            StringBuffer lineBuffer = new StringBuffer();
            eof = patchStream.readLine(lineBuffer);
            line = lineBuffer.toString();
            pos = patchStream.getSeekPosition();
            if (line.startsWith("\\")) {
                String eolStr;
                if (!inHunk) continue;
                patchStream.setSeekPosition(lastLine - 2L);
                StringBuffer buffer = new StringBuffer();
                String s = buffer.toString();
                StringBuffer eolStrBuffer = new StringBuffer();
                eof = patchStream.readLineWithEol(lineBuffer, eolStrBuffer);
                String string = eolStr = eolStrBuffer.length() == 0 ? null : eolStrBuffer.toString();
                long hunkTextEnd = eolStr == null ? lastLine : (eolStr.charAt(0) == '\r' && eolStr.charAt(1) == '\n' ? lastLine - 2L : (eolStr.charAt(0) == '\n' || eolStr.charAt(0) == '\r' ? lastLine - 1L : lastLine));
                if (lastLineType == LineType.ORIGINAL_LINE && originalEnd == 0L) {
                    originalEnd = hunkTextEnd;
                } else if (lastLineType == LineType.MODIFIED_LINE && modifiedEnd == 0L) {
                    modifiedEnd = hunkTextEnd;
                } else if (lastLineType == LineType.CONTEXT_LINE) {
                    if (originalEnd == 0L) {
                        originalEnd = hunkTextEnd;
                    }
                    if (modifiedEnd == 0L) {
                        modifiedEnd = hunkTextEnd;
                    }
                }
                patchStream.setSeekPosition(pos);
                continue;
            }
            if (inHunk && isProperty[0] && propName[0] != null && propName[0].equals("svn:mergeinfo") && (foundMergeInfo = this.parseMergeInfo(line, hunk))) continue;
            if (inHunk) {
                char c;
                int add = 43;
                int del = 45;
                if (!hunkSeen) {
                    start = lastLine;
                }
                char c2 = c = line.length() == 0 ? (char)'\u0000' : line.charAt(0);
                if (originalLines > 0 && modifiedLines > 0 && (c == ' ' || !eof && line.length() == 0 || ignoreWhitespace && c != '-' && c != '+')) {
                    hunkSeen = true;
                    --originalLines;
                    --modifiedLines;
                    if (changedLineSeen) {
                        ++trailingContext;
                    } else {
                        ++leadingContext;
                    }
                    lastLineType = LineType.CONTEXT_LINE;
                    continue;
                }
                if (originalLines > 0 && c == '-') {
                    hunkSeen = true;
                    changedLineSeen = true;
                    if (trailingContext > 0) {
                        trailingContext = 0;
                    }
                    --originalLines;
                    lastLineType = LineType.MODIFIED_LINE;
                    continue;
                }
                if (modifiedLines > 0 && c == '+') {
                    hunkSeen = true;
                    changedLineSeen = true;
                    if (trailingContext > 0) {
                        trailingContext = 0;
                    }
                    --modifiedLines;
                    lastLineType = LineType.MODIFIED_LINE;
                    continue;
                }
                end = eof ? pos : lastLine;
                if (originalEnd == 0L) {
                    originalEnd = end;
                }
                if (modifiedEnd != 0L) break;
                modifiedEnd = end;
                break;
            }
            if (line.startsWith("@@")) {
                inHunk = this.parseHunkHeader(line, hunk, "@@");
                if (!inHunk) continue;
                originalLines = hunk.getOriginalLength();
                modifiedLines = hunk.getModifiedLength();
                isProperty[0] = false;
                continue;
            }
            if (line.startsWith("##")) {
                inHunk = this.parseHunkHeader(line, hunk, "##");
                if (!inHunk) continue;
                originalLines = hunk.getOriginalLength();
                modifiedLines = hunk.getModifiedLength();
                isProperty[0] = true;
                continue;
            }
            if (line.startsWith("Added: ")) {
                propName[0] = this.parsePropName(line, "Added: ");
                if (propName[0] == null) continue;
                propOperation[0] = SvnDiffCallback.OperationKind.Added;
                continue;
            }
            if (line.startsWith("Deleted: ")) {
                propName[0] = this.parsePropName(line, "Deleted: ");
                if (propName[0] == null) continue;
                propOperation[0] = SvnDiffCallback.OperationKind.Deleted;
                continue;
            }
            if (line.startsWith("Modified: ")) {
                propName[0] = this.parsePropName(line, "Modified: ");
                if (propName[0] == null) continue;
                propOperation[0] = SvnDiffCallback.OperationKind.Modified;
                continue;
            }
            if (line.startsWith("--- ") || line.startsWith("diff --git ")) break;
        } while (!eof || line.length() > 0);
        if (!eof) {
            patchStream.setSeekPosition(lastLine);
        }
        if (hunkSeen && start < end) {
            hunk.setPatch(this);
            hunk.setPatchFileStream(patchStream);
            hunk.setLeadingContext(leadingContext);
            hunk.setTrailingContext(trailingContext);
            hunk.setDiffTextRange(new SvnDiffHunk.Range(start, end, start));
            hunk.setOriginalTextRange(new SvnDiffHunk.Range(start, originalEnd, start));
            hunk.setModifiedTextRange(new SvnDiffHunk.Range(start, modifiedEnd, start));
            return hunk;
        }
        hunk = null;
        return hunk;
    }

    private boolean parseMergeInfo(String line, SvnDiffHunk hunk) throws SVNException {
        int slashPos = line.indexOf(47);
        int colonPos = line.indexOf(58);
        boolean foundMergeInfo = false;
        if (slashPos >= 0 && colonPos >= 0 && line.charAt(colonPos + 1) == 'r' && slashPos < colonPos) {
            Map<String, SVNMergeRangeList> mergeInfoMap;
            int s;
            StringBuilder input = new StringBuilder();
            for (s = slashPos; s <= colonPos; ++s) {
                input.append(line.charAt(s));
            }
            ++s;
            while (s < line.length() && !SVNFormatUtil.isSpace(line.charAt(s))) {
                input.append(line.charAt(s));
                ++s;
            }
            try {
                mergeInfoMap = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(input.toString()), null);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.MERGE_INFO_PARSE_ERROR) {
                    mergeInfoMap = null;
                }
                throw e;
            }
            if (mergeInfoMap != null) {
                if (hunk.getOriginalLength() > 0) {
                    if (this.isReverse()) {
                        if (this.getMergeInfo() == null) {
                            this.setMergeInfo(mergeInfoMap);
                        } else {
                            SVNMergeInfoUtil.mergeMergeInfos(this.getMergeInfo(), mergeInfoMap);
                        }
                    } else if (this.getReverseMergeInfo() == null) {
                        this.setReverseMergeInfo(mergeInfoMap);
                    } else {
                        SVNMergeInfoUtil.mergeMergeInfos(this.getReverseMergeInfo(), mergeInfoMap);
                    }
                    hunk.decreaseOriginalLength();
                } else if (hunk.getModifiedLength() > 0) {
                    if (this.isReverse()) {
                        if (this.getReverseMergeInfo() == null) {
                            this.setReverseMergeInfo(mergeInfoMap);
                        } else {
                            SVNMergeInfoUtil.mergeMergeInfos(this.getReverseMergeInfo(), mergeInfoMap);
                        }
                    } else if (this.getMergeInfo() == null) {
                        this.setMergeInfo(mergeInfoMap);
                    } else {
                        SVNMergeInfoUtil.mergeMergeInfos(this.getMergeInfo(), mergeInfoMap);
                    }
                    hunk.decreaseModifiedLength();
                }
                foundMergeInfo = true;
            }
        }
        return foundMergeInfo;
    }

    private String parsePropName(String header, String indicator) throws SVNException {
        String propName = header.substring(indicator.length());
        if (propName.length() == 0) {
            return null;
        }
        if (!SVNPropertiesManager.isValidPropertyName(propName)) {
            return SVNPropertiesManager.isValidPropertyName(propName = propName.trim()) ? propName : null;
        }
        return propName;
    }

    private boolean parseHunkHeader(String header, SvnDiffHunk hunk, String atat) {
        int pos = atat.length();
        if (header.charAt(pos) != ' ') {
            return false;
        }
        if (header.charAt(++pos) != '-') {
            return false;
        }
        StringBuilder range = new StringBuilder();
        int start = ++pos;
        while (pos < header.length() && header.charAt(pos) != ' ') {
            ++pos;
        }
        if (pos == header.length() || header.charAt(pos) != ' ') {
            return false;
        }
        range.append(header.substring(start, pos));
        int[] startArray = new int[1];
        int[] lengthArray = new int[1];
        if (!this.parseRange(startArray, lengthArray, range)) {
            hunk.setOriginalStart(startArray[0]);
            hunk.setOriginalLength(lengthArray[0]);
            return false;
        }
        hunk.setOriginalStart(startArray[0]);
        hunk.setOriginalLength(lengthArray[0]);
        range = new StringBuilder();
        if (header.charAt(++pos) != '+') {
            return false;
        }
        start = ++pos;
        while (pos < header.length() && header.charAt(pos) != ' ') {
            ++pos;
        }
        if (pos == header.length() || header.charAt(pos) != ' ') {
            return false;
        }
        range.append(header.substring(start, pos));
        if (!header.substring(++pos).startsWith(atat)) {
            return false;
        }
        if (!this.parseRange(startArray, lengthArray, range)) {
            hunk.setModifiedStart(startArray[0]);
            hunk.setModifiedLength(lengthArray[0]);
            return false;
        }
        hunk.setModifiedStart(startArray[0]);
        hunk.setModifiedLength(lengthArray[0]);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseRange(int[] start, int[] length, StringBuilder range) {
        if (range.length() == 0) {
            return false;
        }
        int commaPos = range.indexOf(",");
        if (commaPos >= 0) {
            if (range.length() <= 1) return false;
            if (!this.parseOffset(length, range.substring(commaPos + ",".length()))) {
                return false;
            }
            range.setLength(commaPos);
            return this.parseOffset(start, range.toString());
        } else {
            length[0] = 1;
        }
        return this.parseOffset(start, range.toString());
    }

    private boolean parseOffset(int[] offset, String range) {
        String s = range;
        try {
            offset[0] = Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void addPropertyHunk(String propName, SvnDiffHunk hunk, SvnDiffCallback.OperationKind operation) {
        SvnPropertiesPatch propPatch = this.propPatches.get(propName);
        if (propPatch == null) {
            propPatch = new SvnPropertiesPatch(propName, new ArrayList<SvnDiffHunk>(), operation);
            this.propPatches.put(propName, propPatch);
        }
        propPatch.addHunk(hunk);
    }

    public File getOldFileName() {
        return this.oldFileName;
    }

    public File getNewFileName() {
        return this.newFileName;
    }

    public List<SvnDiffHunk> getHunks() {
        return this.hunks;
    }

    public Map<String, SvnPropertiesPatch> getPropPatches() {
        return this.propPatches;
    }

    public SvnDiffCallback.OperationKind getOperation() {
        return this.operation;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public Map getMergeInfo() {
        return this.mergeInfo;
    }

    public Map getReverseMergeInfo() {
        return this.reverseMergeInfo;
    }

    public void setMergeInfo(Map<String, SVNMergeRangeList> mergeInfo) {
        this.mergeInfo = mergeInfo;
    }

    public void setReverseMergeInfo(Map reverseMergeInfo) {
        this.reverseMergeInfo = reverseMergeInfo;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void setOldFileName(File oldFileName) {
        this.oldFileName = oldFileName;
    }

    public void setNewFileName(File newFileName) {
        this.newFileName = newFileName;
    }

    public void setOperation(SvnDiffCallback.OperationKind operation) {
        this.operation = operation;
    }

    private static File grabFileName(String s) {
        return SVNFileUtil.createFilePath(SVNPathUtil.canonicalizePath(s));
    }

    private static enum LineType {
        NOISE_LINE,
        ORIGINAL_LINE,
        MODIFIED_LINE,
        CONTEXT_LINE;

    }

    private static class Transition {
        private String expectedInput;
        private ParserState state;
        private IParserFunction parserFunction;

        public Transition(String expectedInput, ParserState state, IParserFunction parserFunction) {
            this.expectedInput = expectedInput;
            this.state = state;
            this.parserFunction = parserFunction;
        }

        public boolean matches(String line, ParserState state) {
            return line.startsWith(this.expectedInput) && this.state == state;
        }

        private IParserFunction getParserFunction() {
            return this.parserFunction;
        }
    }

    private static interface IParserFunction {
        public static final IParserFunction DIFF_MINUS = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch) {
                String s = line.split("\t")[0].substring("--- ".length());
                patch.setOldFileName(SvnPatch.grabFileName(s));
                return ParserState.MINUS_SEEN;
            }
        };
        public static final IParserFunction DIFF_PLUS = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch) {
                String s = line.split("\t")[0].substring("+++ ".length());
                patch.setNewFileName(SvnPatch.grabFileName(s));
                return ParserState.UNIDIFF_FOUND;
            }
        };
        public static final IParserFunction GIT_START = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch) {
                int oldPathMarkerPos = line.indexOf(" a/");
                if (oldPathMarkerPos < 0) {
                    return ParserState.START;
                }
                if (oldPathMarkerPos + 3 == line.length()) {
                    return ParserState.START;
                }
                int newPathMarkerPos = line.indexOf(" b/");
                if (newPathMarkerPos < 0) {
                    return ParserState.START;
                }
                if (newPathMarkerPos + 3 == line.length()) {
                    return ParserState.START;
                }
                int oldPathStartPos = "diff --git a/".length();
                int newPathEndPos = line.length();
                int newPathStartPos = oldPathStartPos;
                while ((newPathMarkerPos = line.indexOf(" b/", newPathStartPos)) >= 0) {
                    int oldPathEndPos = newPathMarkerPos;
                    newPathStartPos = newPathMarkerPos + " b/".length();
                    if (newPathStartPos == line.length()) break;
                    int lenOld = oldPathEndPos - oldPathStartPos;
                    int lenNew = newPathEndPos - newPathStartPos;
                    if (lenOld != lenNew || !line.substring(oldPathStartPos, oldPathEndPos).equals(line.substring(newPathStartPos, newPathEndPos))) continue;
                    patch.setOldFileName(SvnPatch.grabFileName(line.substring(oldPathStartPos, oldPathEndPos)));
                    patch.setNewFileName(SvnPatch.grabFileName(line.substring(newPathStartPos)));
                    break;
                }
                patch.setOperation(SvnDiffCallback.OperationKind.Modified);
                return ParserState.GIT_DIFF_SEEN;
            }
        };
        public static final IParserFunction GIT_MINUS = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch) {
                String s = line.split("\t")[0];
                if (s.startsWith("--- /dev/null")) {
                    patch.setOldFileName(SvnPatch.grabFileName("/dev/null"));
                } else {
                    patch.setOldFileName(SvnPatch.grabFileName(s.substring("--- a/".length())));
                }
                return ParserState.GIT_MINUS_SEEN;
            }
        };
        public static final IParserFunction GIT_PLUS = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch) {
                String s = line.split("\t")[0];
                if (s.startsWith("+++ /dev/null")) {
                    patch.setNewFileName(SvnPatch.grabFileName("/dev/null"));
                } else {
                    patch.setNewFileName(SvnPatch.grabFileName(s.substring("+++ b/".length())));
                }
                return ParserState.GIT_HEADER_FOUND;
            }
        };
        public static final IParserFunction GIT_MOVE_FROM = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch) {
                patch.setOldFileName(SvnPatch.grabFileName(line.substring("rename from ".length())));
                return ParserState.MOVE_FROM_SEEN;
            }
        };
        public static final IParserFunction GIT_MOVE_TO = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch) {
                patch.setNewFileName(SvnPatch.grabFileName(line.substring("rename to ".length())));
                patch.setOperation(SvnDiffCallback.OperationKind.Moved);
                return ParserState.GIT_TREE_SEEN;
            }
        };
        public static final IParserFunction GIT_COPY_FROM = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch) {
                patch.setOldFileName(SvnPatch.grabFileName(line.substring("copy from ".length())));
                return ParserState.COPY_FROM_SEEN;
            }
        };
        public static final IParserFunction GIT_COPY_TO = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch) {
                patch.setNewFileName(SvnPatch.grabFileName(line.substring("copy to ".length())));
                patch.setOperation(SvnDiffCallback.OperationKind.Copied);
                return ParserState.GIT_TREE_SEEN;
            }
        };
        public static final IParserFunction GIT_NEW_FILE = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch) {
                patch.setOperation(SvnDiffCallback.OperationKind.Added);
                return ParserState.GIT_TREE_SEEN;
            }
        };
        public static final IParserFunction GIT_DELETED_FILE = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch) {
                patch.setOperation(SvnDiffCallback.OperationKind.Deleted);
                return ParserState.GIT_TREE_SEEN;
            }
        };

        public ParserState parse(String var1, SvnPatch var2);
    }

    private static enum ParserState {
        START,
        GIT_DIFF_SEEN,
        GIT_TREE_SEEN,
        GIT_MINUS_SEEN,
        GIT_PLUS_SEEN,
        MOVE_FROM_SEEN,
        COPY_FROM_SEEN,
        MINUS_SEEN,
        UNIDIFF_FOUND,
        GIT_HEADER_FOUND;

    }
}

