/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db.statement;

import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectFieldsStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSelectNodeInfo;

public class SVNWCDbSelectNodeInfoWithLock
extends SVNWCDbSelectNodeInfo {
    private LockStatement lockStatement;

    public SVNWCDbSelectNodeInfoWithLock(SVNSqlJetDb sDb) throws SVNException {
        super(sDb);
        this.lockStatement = new LockStatement(sDb);
    }

    @Override
    public boolean next() throws SVNException {
        this.lockStatement.reset();
        boolean next = super.next();
        if (next) {
            this.lockStatement.bindLong(1, this.getColumnLong(SVNWCDbSchema.NODES__Fields.repos_id.toString()));
            this.lockStatement.bindString(2, this.getColumnString(SVNWCDbSchema.NODES__Fields.repos_path.toString()));
            this.lockStatement.next();
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws SVNException {
        try {
            this.lockStatement.reset();
        }
        finally {
            super.reset();
        }
    }

    @Override
    public SVNSqlJetStatement getJoinedStatement(String joinedTable) throws SVNException {
        if (SVNWCDbSchema.LOCK.toString().equalsIgnoreCase(joinedTable)) {
            return this.lockStatement;
        }
        return super.getJoinedStatement(joinedTable);
    }

    private static class LockStatement
    extends SVNSqlJetSelectFieldsStatement<SVNWCDbSchema.LOCK__Fields> {
        public LockStatement(SVNSqlJetDb sDb) throws SVNException {
            super(sDb, SVNWCDbSchema.LOCK);
        }

        @Override
        protected void defineFields() {
            this.fields.add(SVNWCDbSchema.LOCK__Fields.lock_token);
            this.fields.add(SVNWCDbSchema.LOCK__Fields.lock_owner);
            this.fields.add(SVNWCDbSchema.LOCK__Fields.lock_comment);
            this.fields.add(SVNWCDbSchema.LOCK__Fields.lock_date);
        }
    }
}

