import com.xhaus.jyson.JysonCodec as Json
from xlrelease.HttpRequest import HttpRequest
from com.xebialabs.xlrelease.lookup.api.internal import LookupResultElement

global jiraServer, project

def _createRequest():
    return HttpRequest(jiraServer)

def queryProjects(query):
    request = _createRequest()
    response = request.get('/rest/api/latest/project/search?query={}&orderBy=key&startAt=0&maxResults=50'.format(query), contentType='application/json')
    projects = []

    if response.status == 200:
        data = Json.loads(response.response)
        for item in data['values']:
            label = "(%s) %s" % (item['key'], item['name'])
            projects.append(LookupResultElement(label, item['key']))
    else:
        raise Exception("Failed to execute Jira Query")

    return projects

result = queryProjects(project)
