package com.xebialabs.xlrelease.api.internal;

import org.springframework.stereotype.Controller;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseEventSink;
import java.time.LocalTime;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Path("/test")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@Controller
public class TestResource {

    @GET
    @Produces(MediaType.SERVER_SENT_EVENTS)
    @Path("sse")
    public void streamSseMvc(@Context SseEventSink sink,
                             @Context Sse sse) {
        ExecutorService sseMvcExecutor = Executors.newSingleThreadExecutor();
        sseMvcExecutor.execute(() -> {

            try {
                for (int i = 0; i < 5; i++) {
                    OutboundSseEvent outboundSseEvent = sse.newEvent("log-chunk-entry-created", LocalTime.now().toString());
                    sink.send(outboundSseEvent);
                    Thread.sleep(1000);
                }
                sink.close();

            } catch (Exception e) {
                sink.close();
            }


        });
    }
}
