'use strict';

(function () {
    var LargeDataTestTileController = function ($scope, Backend) {
        var vm = this;
        vm.tileName = "Test Tile";
        var xlrTile = $scope.xlrTile;
        vm.refresh = refresh;

        function load(config) {
            vm.loading = true;
            var tileId = xlrTile.tile.id;
            Backend.get("tiles/" + tileId + "/data", config).then(
                function(response) {
                    vm.data = response.data.data;
                }
            ).finally(function() {
                    vm.loading = false;
            });
        }

        function refresh() {
            load({params: {refresh: true}});
        }

        load();

    };

    LargeDataTestTileController.$inject = ['$scope', 'Backend'];

    angular.module('xlrelease.test.largeDataTile', []);
    angular.module('xlrelease.test.largeDataTile').controller('test.LargeDataTestTileController', LargeDataTestTileController);
})();

