package com.xebialabs.deployit.plumbing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.xml.sax.InputSource;
import com.google.common.io.Files;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.util.GuavaFiles;
import com.xebialabs.xlplatform.repository.RepositoryConfigurationSource;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xlplatform.repository.XlRepositoryInitializer;

import scala.Option;

import static com.xebialabs.xlrelease.upgrade.jcr.XLReleaseUpgrader.XL_RELEASE_COMPONENT;

public class JackrabbitRepositoryBooter {

    private RepositoryImpl repository;

    private File homeDir = Files.createTempDir();

    private XlRepositoryConfig xlConfig;

    public Repository boot() throws RepositoryException {
        xlConfig = new JackrabbitInMemoryConfig();
        try (InputStream stream = xlConfig.jcrRepositoryConfig().getInputStream()) {
            InputSource configurationInputSource = new InputSource(stream);
            RepositoryConfig repositoryConfig = RepositoryConfig.create(configurationInputSource, homeDir.getAbsolutePath());
            repository = RepositoryImpl.create(repositoryConfig);

            new XlRepositoryInitializer(repository, xlConfig).init();
            return repository;
        } catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public void shutdown() {
        repository.shutdown();
        try {
            GuavaFiles.deleteRecursively(homeDir);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RepositoryImpl getRepository() {
        return repository;
    }

    public XlRepositoryConfig getXlConfig() {
        return xlConfig;
    }

    private class JackrabbitInMemoryConfig implements XlRepositoryConfig {

        @Override
        public RepositoryConfigurationSource jcrRepositoryConfig() {
            return new RepositoryConfigurationSource("jackrabbit/inmemory-repository.xml");
        }

        @Override
        public String repositoryName() {
            return XL_RELEASE_COMPONENT;
        }

        @Override
        public Version repositoryVersion() {
            return Version.valueOf(XL_RELEASE_COMPONENT, Version.VERSION_0);
        }

        @Override
        public Option<String> repositoryId() {
            return Option.apply(null);
        }

        @Override
        public Option<? extends Credentials> credentials() {
            return Option.apply(new SimpleCredentials("admin", "admin".toCharArray()));
        }
    }

}
