package com.xebialabs.xlrelease

import java.util

import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.deployit.jcr.JcrTemplate
import com.xebialabs.deployit.plumbing.scheduler.Scheduler
import com.xebialabs.deployit.repository.RepositoryService
import com.xebialabs.license.service.LicenseService
import com.xebialabs.xlrelease.rules.JcrTestRule
import org.mockito.Matchers._
import org.mockito.Mockito._
import org.mockito.invocation.InvocationOnMock
import org.mockito.stubbing.Answer
import org.springframework.security.authentication.{AuthenticationManager, TestingAuthenticationToken}
import org.springframework.security.core.session.SessionRegistry
import org.springframework.security.core.{Authentication, GrantedAuthority}

import scala.beans.BeanProperty

class XLReleaseIntegrationTestConfig {
  @BeanProperty
  var repositoryService: RepositoryService = null

  @BeanProperty
  var jcrTemplate: JcrTemplate = null

  @BeanProperty
  var licenseService: LicenseService = null

  @BeanProperty
  var sessionRegistry: SessionRegistry = null

  @BeanProperty
  var serverConfiguration: ServerConfiguration = null

  @BeanProperty
  var authenticationManager: AuthenticationManager = null

  @BeanProperty
  var scheduler: Scheduler = null
}

object XLReleaseIntegrationTestConfig {
  val instance = new XLReleaseIntegrationTestConfig

  def getInstance(): XLReleaseIntegrationTestConfig = instance

  def init(jcrTestRule: JcrTestRule) {
    instance.repositoryService = jcrTestRule.getRepositoryService
    instance.jcrTemplate = jcrTestRule.getJcrTemplate
    instance.licenseService = mock(classOf[LicenseService])
    instance.sessionRegistry = mock(classOf[SessionRegistry])
    instance.serverConfiguration = new ServerConfiguration
    instance.scheduler = mock(classOf[Scheduler])
    instance.authenticationManager = mock(classOf[AuthenticationManager])
    when(instance.authenticationManager.authenticate(any(classOf[Authentication]))).thenAnswer(new Answer[Authentication] {
      override def answer(invocation: InvocationOnMock): Authentication = {
        val auth = invocation.getArguments()(0).asInstanceOf[Authentication]
        val authorities: util.ArrayList[GrantedAuthority] = new util.ArrayList(auth.getAuthorities)
        new TestingAuthenticationToken(auth.getPrincipal, auth.getCredentials, authorities)
      }
    })
  }
}
