package com.xebialabs.xlrelease.assertions;

import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.mockito.ArgumentCaptor;

import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.repository.ActivityLogs;

import static com.xebialabs.xlrelease.assertions.XLReleaseAssertions.assertThat;
import static com.xebialabs.xlrelease.user.User.AUTHENTICATED_USER;
import static org.mockito.Matchers.anyString;
import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.verify;

public class ActivityLogAssertion  extends AbstractAssert<ActivityLogAssertion, ActivityLogs> {

    protected ActivityLogAssertion(ActivityLogs actual) {
        super(actual, ActivityLogAssertion.class);
    }

    public ActivityLogAssertion logCreated(String activityType) {
        isNotNull();

        ArgumentCaptor<ActivityLogEntry> captor = ArgumentCaptor.forClass(ActivityLogEntry.class);
        verify(actual).log(anyString(), captor.capture());
        assertThat(captor.getValue()).hasActivityType(activityType);
        assertThat(captor.getValue()).hasMessage();

        return this;
    }

    @SuppressWarnings("unchecked")
    public ActivityLogAssertion logsCreated(String... activityTypes) {
        isNotNull();

        ArgumentCaptor<List> captor = ArgumentCaptor.forClass(List.class);
        verify(actual).log(anyString(), captor.capture(), eq(AUTHENTICATED_USER));
        List<?> logs = captor.getValue();
        verifyLogsWithStatuses((List<ActivityLogEntry>) logs, activityTypes);

        return this;
    }

    public static void verifyLogsWithStatuses(List<ActivityLogEntry> activityLogEntries, String... activityTypes) {
        assertThat(activityLogEntries).extracting("activityType").contains((Object[]) activityTypes);
        assertThat(activityLogEntries).hasSize(activityTypes.length);
        assertThat(activityLogEntries).extracting("message").isNotNull();
    }
}
