package com.xebialabs.xlrelease.assertions;

import com.xebialabs.xlrelease.domain.DeployitTask;

import static org.assertj.core.api.Assertions.assertThat;

public class DeployitTaskAssertion extends TaskAssertion {
    private final DeployitTask actualDeployitTask;

    protected DeployitTaskAssertion(DeployitTask actual) {
        super(actual);
        this.actualDeployitTask = actual;
    }

    public DeployitTaskAssertion hasNoDeploymentData() {
        assertThat(actualDeployitTask.getDeployitTaskId()).isNull();
        assertThat(actualDeployitTask.getCurrentStep()).isEqualTo(0);
        assertThat(actualDeployitTask.getTotalStep()).isEqualTo(0);
        assertThat(actualDeployitTask.getCurrentStepTitle()).isNull();
        return this;
    }
}
