package com.xebialabs.xlrelease.rules;

import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

import com.xebialabs.deployit.event.EventBusHolder;

import static com.google.common.collect.Lists.newArrayList;

public abstract class EventsRule<T> implements TestRule {
    private List<T> capturedEvents = newArrayList();

    @Override
    public Statement apply(final Statement base, Description description) {
        return new Statement() {
            @Override
            public void evaluate() throws Throwable {
                EventBusHolder.register(EventsRule.this);
                try {
                    base.evaluate();
                } finally {
                    EventBusHolder.deregister(EventsRule.this);
                }
            }
        };
    }

    public List<T> getCapturedEvents() {
        return capturedEvents;
    }

    protected void capture(T event) {
        capturedEvents.add(event);
    }
}
