package com.xebialabs.xlrelease.rules;

import java.security.Security;
import javax.jcr.Repository;

import com.xebialabs.deployit.repository.RepositoryMetadataService;
import com.xebialabs.xlplatform.repository.JcrRepositoryMetadataService;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.rules.ExternalResource;

import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.plumbing.JackrabbitRepositoryBooter;
import com.xebialabs.deployit.repository.JcrRepositoryService;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.license.service.LicenseServiceImpl;
import com.xebialabs.xlrelease.config.XlrConfig;

import static com.xebialabs.deployit.util.DeployitKeys.DEFAULT_PASSWORD_ENCRYPTION_KEY;
import static com.xebialabs.license.License.PRODUCT_XL_RELEASE;

public class JcrTestRule extends ExternalResource {

    private JcrTemplate jcrTemplate;

    private JcrRepositoryService repositoryService;

    private JackrabbitRepositoryBooter booter;

    @Override
    public void before() throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        PasswordEncrypter.init(DEFAULT_PASSWORD_ENCRYPTION_KEY);

        booter = new JackrabbitRepositoryBooter();
        Repository repo = booter.boot();
        jcrTemplate = new JcrTemplate(repo, booter.getXlConfig().credentials().get());
        // Set the template in the holder
        new JcrTemplateHolder(jcrTemplate);

        RepositoryMetadataService repositoryMetadataService = new JcrRepositoryMetadataService(jcrTemplate);
        LicenseServiceImpl licenseService = new LicenseServiceImpl(XlrConfig.license_location(), PRODUCT_XL_RELEASE, repositoryMetadataService);
        repositoryService = new JcrRepositoryService(jcrTemplate, PasswordEncrypter.getInstance(), licenseService);
        licenseService.initialize(repositoryService);
    }

    @Override
    public void after() {
        booter.shutdown();
    }

    public JcrTemplate getJcrTemplate() {
        return jcrTemplate;
    }

    public RepositoryService getRepositoryService() {
        return repositoryService;
    }

}
