package com.xebialabs.xlrelease.service;

import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.api.XLReleaseServiceHolder;
import com.xebialabs.xlrelease.api.v1.PhaseApi;
import com.xebialabs.xlrelease.api.v1.ReleaseApi;
import com.xebialabs.xlrelease.api.v1.TaskApi;
import com.xebialabs.xlrelease.api.v1.TemplateApi;

@Component
public class TestServiceStarter {
    private TaskApi taskApi;
    private RepositoryService repositoryService;
    private PhaseApi phaseApi;
    private ReleaseApi releaseApi;
    private TemplateApi templateApi;

    @Autowired
    public TestServiceStarter(RepositoryService repositoryService, TaskApi taskApi,
                              PhaseApi phaseApi, ReleaseApi releaseApi, TemplateApi templateApi) {
        this.taskApi = taskApi;
        this.repositoryService = repositoryService;
        this.phaseApi = phaseApi;
        this.releaseApi = releaseApi;
        this.templateApi = templateApi;
    }

    @PostConstruct
    public void startServices() {
        XLReleaseServiceHolder.init(taskApi, phaseApi, releaseApi, templateApi, repositoryService);
    }

}
