package com.xebialabs.xlrelease;

import com.xebialabs.xlrelease.repository.UserProfiles;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.APPLICATIONS;

/**
 * Holds sets of ids to use in unit tests.
 * <p>
 * More and more business code depends on properly formed ids with coherent nesting. It's more convenient to define them once and for all here.
 * </p>
 */
public final class TestIds {
    public static final String RELEASES_DIR = APPLICATIONS.getRootNodeName() + "/ReleasesTest";

    public static final String RELEASE1 = RELEASES_DIR + "/Release1";
    public static final String RELEASE_TRIGGER11 = RELEASE1 + "/ReleaseTrigger1";
    public static final String RELEASE_TRIGGER12 = RELEASE1 + "/ReleaseTrigger2";
    public static final String TEAM11 = RELEASE1 + "/Team1";
    public static final String TEAM12 = RELEASE1 + "/Team2";
    public static final String TEAM13 = RELEASE1 + "/Team3";
    public static final String PHASE11 = RELEASE1 + "/Phase1";
    public static final String TASK111 = PHASE11 + "/Task1";
    public static final String TASK1111 = TASK111 + "/Task1";
    public static final String TASK11111 = TASK1111 + "/Task1";
    public static final String TASK1112 = TASK111 + "/Task2";
    public static final String COMMENT1111 = TASK111 + "/Comment1";
    public static final String TASK112 = PHASE11 + "/Task2";
    public static final String COMMENT1121 = TASK112 + "/Comment1";
    public static final String PHASE12 = RELEASE1 + "/Phase2";
    public static final String TASK121 = PHASE12 + "/Task1";
    public static final String TASK122 = PHASE12 + "/Task2";
    public static final String PHASE13 = RELEASE1 + "/Phase3";
    public static final String TASK131 = PHASE13 + "/Task1";
    public static final String LINK01_ID = TASK111 + "/Link01";
    public static final String LINK02_ID = TASK111 + "/Link02";
    public static final String DEPENDENCY1111 = TASK111 + "/Dependency1";
    public static final String ATTACHMENT1 = RELEASE1 + "/Attachment1";
    public static final String ATTACHMENT2 = RELEASE1 + "/Attachment2";
    public static final String VARIABLE11 = RELEASE1 + "/Variable1";
    public static final String VARIABLE12 = RELEASE1 + "/Variable2";
    public static final String VARIABLE13 = RELEASE1 + "/Variable3";

    public static final String RELEASE2 = RELEASES_DIR + "/Release2";
    public static final String PHASE21 = RELEASE2 + "/Phase1";
    public static final String TASK211 = PHASE21 + "/Task1";
    public static final String VARIABLE21 = RELEASE2 + "/Variable1";

    public static final String RELEASE3 = RELEASES_DIR + "/Release3";
    public static final String PHASE31 = RELEASE3 + "/Phase1";
    public static final String TASK311 = PHASE31 + "/Task1";

    public static final String RELEASE4 = RELEASES_DIR + "/Release4";

    public static final String RELEASE5 = RELEASES_DIR + "/Release5";

    public static final String TEMPLATE1 = RELEASES_DIR + "/ReleaseTemplate1";

    public static final String USER1 = UserProfiles.ROOT + "John";

    private TestIds() {
        throw new AssertionError();
    }
}
