package com.xebialabs.xlrelease

import com.xebialabs.deployit.booter.local.LocalBooter
import com.xebialabs.deployit.util.DeployitKeys._
import com.xebialabs.deployit.util.PasswordEncrypter
import grizzled.slf4j.Logging
import org.scalatest._
import org.scalatest.mock.MockitoSugar
import org.springframework.security.core.Authentication
import org.springframework.security.core.context.SecurityContextHolder

trait XLReleaseScalaTest
  extends FunSpecLike
  with Matchers
  with BeforeAndAfterAll
  with BeforeAndAfterEach
  with MockitoSugar
  with Logging {

  LocalBooter.bootWithoutGlobalContext()
  PasswordEncrypter.init(DEFAULT_PASSWORD_ENCRYPTION_KEY)


  def withAuthentication(auth: Authentication)(t: => Unit): Unit = {
    val origAuth = SecurityContextHolder.getContext.getAuthentication
    SecurityContextHolder.getContext.setAuthentication(auth)
    try {
      t
    } finally {
      SecurityContextHolder.getContext.setAuthentication(origAuth)
    }
  }
}
