package com.xebialabs.xlrelease.assertions;

import org.assertj.core.api.AbstractAssert;

import com.xebialabs.xlrelease.domain.ActivityLogEntry;

import static com.xebialabs.xlrelease.assertions.XLReleaseAssertions.assertThat;

public class ActivityLogEntryAssertion extends AbstractAssert<ActivityLogEntryAssertion, ActivityLogEntry> {

    protected ActivityLogEntryAssertion(ActivityLogEntry actual) {
        super(actual, ActivityLogEntryAssertion.class);
    }

    public ActivityLogEntryAssertion hasActivityType(String activityType) {
        isNotNull();
        assertThat(actual.getActivityType()).isEqualTo(activityType);
        return this;
    }

    public ActivityLogEntryAssertion hasDate() {
        isNotNull();
        assertThat(actual.getEventTime()).isNotNull();
        return this;
    }

    public ActivityLogEntryAssertion hasUsername(String username) {
        isNotNull();
        assertThat(actual.getUsername()).isEqualTo(username);
        return this;
    }

    public ActivityLogEntryAssertion hasMessage() {
        isNotNull();
        assertThat(actual.getMessage()).isNotNull();
        return this;
    }
}
