package com.xebialabs.xlrelease.assertions;

import java.util.List;
import org.assertj.core.api.AbstractAssert;
import com.google.common.base.Function;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.ReleaseActivity;

import static com.google.common.collect.Lists.transform;
import static com.xebialabs.xlrelease.assertions.XLReleaseAssertions.assertThat;

public class ChangesAssertion extends AbstractAssert<ChangesAssertion, Changes> {
    protected ChangesAssertion(Changes actual) {
        super(actual, ChangesAssertion.class);
    }

    public ChangesAssertion containsOnlyUpdatedItems(ConfigurationItem... items) {
        assertThat(actual.getUpdatedItems()).containsOnly(items);
        return this;
    }

    public final ChangesAssertion containsOnlyLogTypes(ReleaseActivity... expectedTypes) {
        String[] expectedTypesAsStrings = new String[expectedTypes.length];
        for (int i = 0; i < expectedTypes.length; i++) {
            expectedTypesAsStrings[i] = expectedTypes[i].name();
        }
        List<ActivityLogEntry> actualLogs = actual.getActivityLogEntries();
        assertThat(actualLogs).extracting("activityType").containsOnly((Object[]) expectedTypesAsStrings);
        return this;
    }

    public ChangesAssertion containsOnlyRemovedIds(String... ids) {
        assertThat(actual.getRemovedIds()).containsOnly(ids);
        return this;
    }

    public ChangesAssertion containsOnlyEventTypes(Class<?>... expectedEventTypes) {
        List<Class<?>> eventTypes = transform(actual.getEvents(), new Function<Object, Class<?>>() {
            @Override
            public Class<?> apply(Object input) {
                return input.getClass();
            }
        });
        assertThat(eventTypes).containsOnly(expectedEventTypes);
        return this;
    }
}
