/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.assertions;

import com.xebialabs.xlrelease.assertions.XLReleaseAssertions;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.repository.ActivityLogs;
import com.xebialabs.xlrelease.user.User;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ActivityLogAssertion
extends AbstractAssert<ActivityLogAssertion, ActivityLogs> {
    protected ActivityLogAssertion(ActivityLogs actual) {
        super((Object)actual, ActivityLogAssertion.class);
    }

    public ActivityLogAssertion logCreated(String activityType) {
        return this.logCreated(activityType, null);
    }

    public ActivityLogAssertion logCreated(String activityType, String message) {
        this.isNotNull();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ActivityLogEntry.class);
        ((ActivityLogs)Mockito.verify((Object)this.actual)).log(Matchers.anyString(), (ActivityLogEntry)captor.capture());
        XLReleaseAssertions.assertThat((ActivityLogEntry)captor.getValue()).hasActivityType(activityType);
        XLReleaseAssertions.assertThat((ActivityLogEntry)captor.getValue()).hasMessage();
        if (message != null) {
            XLReleaseAssertions.assertThat((String)((ActivityLogEntry)captor.getValue()).getMessage()).isEqualTo((Object)message);
        }
        return this;
    }

    public ActivityLogAssertion logsCreated(String ... activityTypes) {
        return this.logsCreated(User.AUTHENTICATED_USER, activityTypes);
    }

    public ActivityLogAssertion logsCreated(User user, String ... activityTypes) {
        return this.logsCreated(user, Arrays.asList(activityTypes), null);
    }

    public ActivityLogAssertion logsCreated(User user, List<String> activityTypes, List<String> messages) {
        this.isNotNull();
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        if (null == user) {
            ((ActivityLogs)Mockito.verify((Object)this.actual)).log(Matchers.anyString(), (List)captor.capture());
        } else {
            ((ActivityLogs)Mockito.verify((Object)this.actual)).log(Matchers.anyString(), (List)captor.capture(), (User)Matchers.eq((Object)user));
        }
        List logs = (List)captor.getValue();
        ActivityLogAssertion.verifyLogsWithStatuses((List<ActivityLogEntry>)logs, activityTypes, messages);
        return this;
    }

    public static void verifyLogsWithStatuses(List<ActivityLogEntry> activityLogEntries, String ... activityTypes) {
        ActivityLogAssertion.verifyLogsWithStatuses(activityLogEntries, Arrays.asList(activityTypes), null);
    }

    public static void verifyLogsWithStatuses(List<ActivityLogEntry> activityLogEntries, List<String> activityTypes, List<String> messages) {
        XLReleaseAssertions.assertThat(activityLogEntries).extracting("activityType").containsAll(activityTypes);
        if (messages != null) {
            XLReleaseAssertions.assertThat(activityLogEntries).extracting("message").containsAll(messages);
        } else {
            XLReleaseAssertions.assertThat(activityLogEntries).extracting("message").isNotNull();
        }
        XLReleaseAssertions.assertThat(activityLogEntries).hasSize(activityTypes.size());
    }
}

