/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.assertions;

import com.xebialabs.xlrelease.assertions.PlanItemAssertion;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.StringAssert;

public class TaskAssertion
extends PlanItemAssertion<TaskAssertion, Task> {
    protected TaskAssertion(Task actual) {
        super(actual, TaskAssertion.class);
    }

    public TaskAssertion hasStatus(TaskStatus status) {
        this.isNotNull();
        Assertions.assertThat((Object)((Task)this.actual).getStatus()).isEqualTo((Object)status);
        return this;
    }

    @Override
    public TaskAssertion hasId(String id) {
        this.isNotNull();
        Assertions.assertThat((String)((Task)this.actual).getId()).isEqualTo((Object)id);
        return this;
    }

    public TaskAssertion isPlanned() {
        ((TaskAssertion)this.isNotNull()).hasStatus(TaskStatus.PLANNED);
        return this;
    }

    public TaskAssertion isInProgress() {
        ((TaskAssertion)this.isNotNull()).hasStatus(TaskStatus.IN_PROGRESS).hasStartDate();
        return this;
    }

    public TaskAssertion isSkipped() {
        ((TaskAssertion)this.isNotNull()).hasStatus(TaskStatus.SKIPPED);
        return this;
    }

    public TaskAssertion isFailing() {
        ((TaskAssertion)this.isNotNull()).hasStatus(TaskStatus.FAILING);
        return this;
    }

    public TaskAssertion isDone() {
        Assertions.assertThat((boolean)((Task)this.actual).getStatus().isDone()).isTrue();
        ((TaskAssertion)this.isNotNull()).hasEndDate();
        return this;
    }

    public TaskAssertion isFailed() {
        ((TaskAssertion)this.isNotNull()).hasStatus(TaskStatus.FAILED);
        return this;
    }

    public TaskAssertion hasBeenFailed(int expectedFailuresCount) {
        this.isNotNull();
        Assertions.assertThat((int)((Task)this.actual).getFailuresCount()).isEqualTo(expectedFailuresCount);
        return this;
    }

    public TaskAssertion hasBeenFlagged() {
        this.isNotNull();
        Assertions.assertThat((boolean)((Task)this.actual).hasBeenFlagged()).isTrue();
        return this;
    }

    public TaskAssertion hasNotBeenFlagged() {
        this.isNotNull();
        Assertions.assertThat((boolean)((Task)this.actual).hasBeenFlagged()).isFalse();
        return this;
    }

    public TaskAssertion hasBeenDelayed() {
        this.isNotNull();
        Assertions.assertThat((boolean)((Task)this.actual).hasBeenDelayed()).isTrue();
        return this;
    }

    public TaskAssertion hasNotBeenDelayed() {
        this.isNotNull();
        Assertions.assertThat((boolean)((Task)this.actual).hasBeenDelayed()).isFalse();
        return this;
    }

    public TaskAssertion isCompleted() {
        ((TaskAssertion)this.isNotNull()).hasStatus(TaskStatus.COMPLETED);
        ((TaskAssertion)this.isNotNull()).hasEndDate();
        return this;
    }

    public TaskAssertion isCompletedInAdvance() {
        ((TaskAssertion)this.isNotNull()).hasStatus(TaskStatus.COMPLETED_IN_ADVANCE);
        ((TaskAssertion)this.isNotNull()).hasEndDate();
        return this;
    }

    public TaskAssertion isSkippedInAdvance() {
        ((TaskAssertion)this.isNotNull()).hasStatus(TaskStatus.SKIPPED_IN_ADVANCE);
        ((TaskAssertion)this.isNotNull()).hasEndDate();
        return this;
    }

    public TaskAssertion isAborted() {
        ((TaskAssertion)this.isNotNull()).hasStatus(TaskStatus.ABORTED);
        ((TaskAssertion)this.isNotNull()).hasEndDate();
        return this;
    }

    public TaskAssertion isPending() {
        ((TaskAssertion)this.isNotNull()).hasStatus(TaskStatus.PENDING);
        return this;
    }

    public TaskAssertion isPreconditionInProgress() {
        ((TaskAssertion)this.isNotNull()).hasStatus(TaskStatus.PRECONDITION_IN_PROGRESS);
        return this;
    }

    public TaskAssertion isWaitingForInput() {
        ((TaskAssertion)this.isNotNull()).hasStatus(TaskStatus.WAITING_FOR_INPUT);
        return this;
    }

    @Override
    public TaskAssertion hasOwner(String owner) {
        this.isNotNull();
        Assertions.assertThat((String)((Task)this.actual).getOwner()).isEqualTo((Object)owner);
        return this;
    }

    public TaskAssertion hasTitle(String title) {
        this.isNotNull();
        Assertions.assertThat((String)((Task)this.actual).getTitle()).isEqualTo((Object)title);
        return this;
    }

    public TaskAssertion hasDescription(String description) {
        this.isNotNull();
        Assertions.assertThat((String)((Task)this.actual).getDescription()).isEqualTo((Object)description);
        return this;
    }

    public TaskAssertion hasTeam(String team) {
        this.isNotNull();
        Assertions.assertThat((String)((Task)this.actual).getTeam()).isEqualTo((Object)team);
        return this;
    }

    public TaskAssertion hasIdContaining(String text) {
        this.isNotNull();
        ((StringAssert)Assertions.assertThat((String)((Task)this.actual).getId()).isNotNull()).contains(new CharSequence[]{text});
        return this;
    }

    public TaskAssertion isWaitingForScheduledStartDate() {
        this.isNotNull();
        Assertions.assertThat((boolean)((Task)this.actual).isWaitForScheduledStartDate()).isTrue();
        return this;
    }

    public TaskAssertion isNotWaitingForScheduledStartDate() {
        this.isNotNull();
        Assertions.assertThat((boolean)((Task)this.actual).isWaitForScheduledStartDate()).isFalse();
        return this;
    }
}

