/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.engine.spi.event.CisCreatedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.xlrelease.domain.Comment;
import java.io.Closeable;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import nl.javadude.t2bus.Subscribe;

public class TaskCommentsAwaiter
implements Closeable {
    private static final long TIMEOUT = 3000L;
    private int expectedNumComments;
    private String taskId;
    private CountDownLatch latch = new CountDownLatch(1);
    private Set<Comment> comments = Sets.newHashSet();

    public TaskCommentsAwaiter(String taskId, int expectedNumComments) {
        this.expectedNumComments = expectedNumComments;
        this.taskId = taskId;
        EventBusHolder.register((Object)this);
    }

    public void awaitComments() throws InterruptedException, TimeoutException {
        if (!this.latch.await(3000L, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException(String.format("task %s did not have %s comments within timeout", this.taskId, this.expectedNumComments));
        }
    }

    @Subscribe
    public void onCommentCreatedEvent(CisCreatedEvent event) {
        event.getCis().stream().filter(ci -> ci instanceof Comment).map(ci -> (Comment)ci).filter(comment -> comment.getId().contains(this.taskId)).forEach(comment -> {
            this.comments.add((Comment)comment);
            if (this.comments.size() >= this.expectedNumComments) {
                this.latch.countDown();
            }
        });
    }

    @Override
    public void close() {
        EventBusHolder.deregister((Object)this);
    }
}

