/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.rules;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.junit.rules.ExternalResource;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;

public class LoginRule
extends ExternalResource {
    private static final String DEFAULT_PASSWORD = "password";
    private final String username;
    private final String password;
    private List<String> authorities;

    private LoginRule(String username, String password, String ... authorities) {
        this.username = username;
        this.password = password;
        this.authorities = org.assertj.core.util.Lists.newArrayList((Object[])authorities);
    }

    public static LoginRule loginWith(String username) {
        return new LoginRule(username, DEFAULT_PASSWORD, new String[0]);
    }

    public static LoginRule loginWithRoleAdmin(String username) {
        return new LoginRule(username, DEFAULT_PASSWORD, "ROLE_ADMIN");
    }

    public void logout() {
        Permissions.clearSecurityContext();
    }

    public void before() throws Throwable {
        SecurityContextImpl context = new SecurityContextImpl();
        context.setAuthentication((Authentication)new TestingAuthenticationToken((Object)this.username, (Object)this.password, this.authorities.toArray(new String[this.authorities.size()])));
        SecurityContextHolder.setContext((SecurityContext)context);
    }

    public void after() {
        Permissions.clearSecurityContext();
    }

    public static void grantAdminPermissionTo(String username, PermissionEditor permissionEditor, RoleService roleService) {
        Role roleWithAdminPermission = new Role(String.valueOf(roleService.getRoles().size()), "RoleWithAdminPermission");
        roleWithAdminPermission.getPrincipalsAssigned().add(username);
        HashMap<Role, Set<Permission>> rolePermission = new HashMap<Role, Set<Permission>>();
        rolePermission.put(roleWithAdminPermission, Collections.singleton(PlatformPermissions.ADMIN));
        permissionEditor.editPermissions("global", rolePermission);
        roleService.writeRoleAssignments((List)Lists.newArrayList((Object[])new Role[]{roleWithAdminPermission}));
    }

    public static void addUserToRole(String username, String roleName, RoleService roleService) {
        Role role = new Role(String.valueOf(roleService.getRoles().size()), roleName);
        role.getPrincipalsAssigned().add(username);
        roleService.writeRoleAssignments((List)Lists.newArrayList((Object[])new Role[]{role}));
    }

    public static void clearPermissions(PermissionEditor permissionEditor, RoleService roleService) {
        HashMap rolePermission = new HashMap();
        permissionEditor.editPermissions("global", rolePermission);
        roleService.writeRoleAssignments((List)Lists.newArrayList());
    }
}

