/*
 * Decompiled with CFR 0.152.
 */
package com.mattbertolini.liquibase.logging.slf4j;

import com.mattbertolini.liquibase.logging.slf4j.Slf4jLogger;
import java.util.Properties;
import liquibase.logging.Logger;
import liquibase.logging.core.AbstractLogService;
import org.slf4j.LoggerFactory;

public class Slf4jLogService
extends AbstractLogService {
    private static final int DEFAULT_PRIORITY = 5;
    private static final String PRIORITY_PROPERTY_NAME = Slf4jLogService.class.getName() + ".priority";
    private int priority = 5;

    public Slf4jLogService() {
        this(System.getProperties());
    }

    Slf4jLogService(Properties systemProps) {
        String priorityPropertyValue = systemProps.getProperty(PRIORITY_PROPERTY_NAME);
        if (priorityPropertyValue != null && !priorityPropertyValue.isEmpty()) {
            try {
                this.priority = Integer.parseInt(priorityPropertyValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public Logger getLog(Class clazz) {
        return new Slf4jLogger(LoggerFactory.getLogger((Class)clazz), this.getFilter());
    }
}

