/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.python.antlr.PythonTree;
import org.python.antlr.Visitor;
import org.python.antlr.ast.ClassDef;
import org.python.antlr.ast.DictComp;
import org.python.antlr.ast.Exec;
import org.python.antlr.ast.Expression;
import org.python.antlr.ast.FunctionDef;
import org.python.antlr.ast.GeneratorExp;
import org.python.antlr.ast.Global;
import org.python.antlr.ast.Import;
import org.python.antlr.ast.ImportFrom;
import org.python.antlr.ast.Interactive;
import org.python.antlr.ast.Lambda;
import org.python.antlr.ast.ListComp;
import org.python.antlr.ast.Module;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.Return;
import org.python.antlr.ast.SetComp;
import org.python.antlr.ast.Tuple;
import org.python.antlr.ast.With;
import org.python.antlr.ast.Yield;
import org.python.antlr.ast.arguments;
import org.python.antlr.ast.comprehension;
import org.python.antlr.ast.expr_contextType;
import org.python.antlr.base.expr;
import org.python.antlr.base.stmt;
import org.python.compiler.ArgListCompiler;
import org.python.compiler.CompilationContext;
import org.python.compiler.Future;
import org.python.compiler.ScopeConstants;
import org.python.compiler.ScopeInfo;
import org.python.core.ParserFacade;

public class ScopesCompiler
extends Visitor
implements ScopeConstants {
    private CompilationContext code_compiler;
    private Stack<ScopeInfo> scopes;
    private ScopeInfo cur = null;
    private Hashtable<PythonTree, ScopeInfo> nodeScopes;
    private int level = 0;
    private int func_level = 0;

    public ScopesCompiler(CompilationContext code_compiler, Hashtable<PythonTree, ScopeInfo> nodeScopes) {
        this.code_compiler = code_compiler;
        this.nodeScopes = nodeScopes;
        this.scopes = new Stack();
    }

    public void beginScope(String name, int kind, PythonTree node, ArgListCompiler ac) {
        if (this.cur != null) {
            this.scopes.push(this.cur);
        }
        if (kind == 1) {
            ++this.func_level;
        }
        this.cur = new ScopeInfo(name, node, this.level++, kind, this.func_level, ac);
        this.nodeScopes.put(node, this.cur);
    }

    public void endScope() throws Exception {
        if (this.cur.kind == 1) {
            --this.func_level;
        }
        --this.level;
        ScopeInfo up = null;
        if (!this.scopes.empty()) {
            up = this.scopes.pop();
        }
        int dist2 = 1;
        ScopeInfo referenceable = up;
        int i = this.scopes.size() - 1;
        while (i >= 0 && referenceable.kind == 2) {
            referenceable = (ScopeInfo)this.scopes.get(i);
            --i;
            ++dist2;
        }
        this.cur.cook(referenceable, dist2, this.code_compiler);
        this.cur.dump();
        this.cur = up;
    }

    public void parse(PythonTree node) throws Exception {
        try {
            this.visit(node);
        }
        catch (Throwable t) {
            throw ParserFacade.fixParseError(null, t, this.code_compiler.getFilename());
        }
    }

    @Override
    public Object visitInteractive(Interactive node) throws Exception {
        this.beginScope("<single-top>", 0, node, null);
        this.suite(node.getInternalBody());
        this.endScope();
        return null;
    }

    @Override
    public Object visitModule(Module node) throws Exception {
        this.beginScope("<file-top>", 0, node, null);
        this.suite(node.getInternalBody());
        this.endScope();
        return null;
    }

    @Override
    public Object visitExpression(Expression node) throws Exception {
        this.beginScope("<eval-top>", 0, node, null);
        this.visit(new Return(node, node.getInternalBody()));
        this.endScope();
        return null;
    }

    private void def(String name) {
        this.cur.addBound(name);
    }

    @Override
    public Object visitFunctionDef(FunctionDef node) throws Exception {
        int i;
        this.def(node.getInternalName());
        ArgListCompiler ac = new ArgListCompiler();
        ac.visitArgs(node.getInternalArgs());
        List<expr> defaults = ac.getDefaults();
        for (int i2 = 0; i2 < defaults.size(); ++i2) {
            this.visit(defaults.get(i2));
        }
        List<expr> decs = node.getInternalDecorator_list();
        for (int i3 = decs.size() - 1; i3 >= 0; --i3) {
            this.visit(decs.get(i3));
        }
        this.beginScope(node.getInternalName(), 1, node, ac);
        int n = ac.names.size();
        for (i = 0; i < n; ++i) {
            this.cur.addParam(ac.names.get(i));
        }
        for (i = 0; i < ac.init_code.size(); ++i) {
            this.visit(ac.init_code.get(i));
        }
        this.cur.markFromParam();
        this.suite(node.getInternalBody());
        this.endScope();
        return null;
    }

    @Override
    public Object visitLambda(Lambda node) throws Exception {
        ArgListCompiler ac = new ArgListCompiler();
        ac.visitArgs(node.getInternalArgs());
        List<expr> defaults = ac.getDefaults();
        for (int i = 0; i < defaults.size(); ++i) {
            this.visit(defaults.get(i));
        }
        this.beginScope("<lambda>", 1, node, ac);
        for (String string2 : ac.names) {
            this.cur.addParam(string2);
        }
        for (Object object : ac.init_code) {
            this.visit((stmt)object);
        }
        this.cur.markFromParam();
        this.visit(node.getInternalBody());
        this.endScope();
        return null;
    }

    public void suite(List<stmt> stmts) throws Exception {
        for (int i = 0; i < stmts.size(); ++i) {
            this.visit(stmts.get(i));
        }
    }

    @Override
    public Object visitImport(Import node) throws Exception {
        for (int i = 0; i < node.getInternalNames().size(); ++i) {
            if (node.getInternalNames().get(i).getInternalAsname() != null) {
                this.cur.addBound(node.getInternalNames().get(i).getInternalAsname());
                continue;
            }
            String name = node.getInternalNames().get(i).getInternalName();
            if (name.indexOf(46) > 0) {
                name = name.substring(0, name.indexOf(46));
            }
            this.cur.addBound(name);
        }
        return null;
    }

    @Override
    public Object visitImportFrom(ImportFrom node) throws Exception {
        Future.checkFromFuture(node);
        int n = node.getInternalNames().size();
        if (n == 0) {
            this.cur.from_import_star = true;
            return null;
        }
        for (int i = 0; i < n; ++i) {
            if (node.getInternalNames().get(i).getInternalAsname() != null) {
                this.cur.addBound(node.getInternalNames().get(i).getInternalAsname());
                continue;
            }
            this.cur.addBound(node.getInternalNames().get(i).getInternalName());
        }
        return null;
    }

    @Override
    public Object visitGlobal(Global node) throws Exception {
        int n = node.getInternalNames().size();
        for (int i = 0; i < n; ++i) {
            String name = node.getInternalNames().get(i);
            int prev = this.cur.addGlobal(name);
            if (prev < 0) continue;
            if ((prev & 8) != 0) {
                this.code_compiler.error("name '" + name + "' is local and global", true, node);
            }
            if ((prev & 0x42) != 0) continue;
            String what = (prev & 1) != 0 ? "assignment" : "use";
            this.code_compiler.error("name '" + name + "' declared global after " + what, false, node);
        }
        return null;
    }

    @Override
    public Object visitExec(Exec node) throws Exception {
        this.cur.exec = true;
        if (node.getInternalGlobals() == null && node.getInternalLocals() == null) {
            this.cur.unqual_exec = true;
        }
        this.traverse(node);
        return null;
    }

    @Override
    public Object visitClassDef(ClassDef node) throws Exception {
        List<expr> decs = node.getInternalDecorator_list();
        for (int i = decs.size() - 1; i >= 0; --i) {
            this.visit(decs.get(i));
        }
        this.def(node.getInternalName());
        int n = node.getInternalBases().size();
        for (int i = 0; i < n; ++i) {
            this.visit(node.getInternalBases().get(i));
        }
        this.beginScope(node.getInternalName(), 2, node, null);
        this.suite(node.getInternalBody());
        this.endScope();
        return null;
    }

    @Override
    public Object visitName(Name node) throws Exception {
        String name = node.getInternalId();
        if (node.getInternalCtx() != expr_contextType.Load) {
            if (name.equals("__debug__")) {
                this.code_compiler.error("can not assign to __debug__", true, node);
            }
            this.cur.addBound(name);
        } else {
            this.cur.addUsed(name);
        }
        return null;
    }

    @Override
    public Object visitListComp(ListComp node) throws Exception {
        String tmp = "_[" + node.getLineno() + "_" + node.getCol_offset() + "]";
        this.cur.addBound(tmp);
        this.traverse(node);
        return null;
    }

    @Override
    public Object visitDictComp(DictComp node) throws Exception {
        List<expr> kv = Arrays.asList(node.getInternalKey(), node.getInternalValue());
        return this.visitInternalGenerators(node, new Tuple(node, kv, expr_contextType.UNDEFINED), node.getInternalGenerators());
    }

    @Override
    public Object visitSetComp(SetComp node) throws Exception {
        return this.visitInternalGenerators(node, node.getInternalElt(), node.getInternalGenerators());
    }

    @Override
    public Object visitYield(Yield node) throws Exception {
        this.cur.defineAsGenerator(node);
        ++this.cur.yield_count;
        this.traverse(node);
        return null;
    }

    @Override
    public Object visitReturn(Return node) throws Exception {
        if (node.getInternalValue() != null) {
            this.cur.noteReturnValue(node);
        }
        this.traverse(node);
        return null;
    }

    private Object visitInternalGenerators(expr node, expr elt, List<comprehension> generators) throws Exception {
        if (generators != null && generators.size() > 0) {
            this.visit(generators.get(0).getInternalIter());
        }
        String bound_exp = "_(x)";
        String tmp = "_(" + node.getLineno() + "_" + node.getCol_offset() + ")";
        this.def(tmp);
        ArgListCompiler ac = new ArgListCompiler();
        ArrayList<expr> args = new ArrayList<expr>();
        args.add(new Name(node.getToken(), bound_exp, expr_contextType.Param));
        ac.visitArgs(new arguments(node, args, null, null, new ArrayList<expr>()));
        this.beginScope(tmp, 1, node, ac);
        this.cur.addParam(bound_exp);
        this.cur.markFromParam();
        this.cur.defineAsGenerator(node);
        ++this.cur.yield_count;
        if (elt != null) {
            this.visit(elt);
        }
        if (generators != null) {
            for (int i = 0; i < generators.size(); ++i) {
                if (generators.get(i) == null) continue;
                if (i == 0) {
                    this.visit(generators.get(i).getInternalTarget());
                    if (generators.get(i).getInternalIfs() == null) continue;
                    for (expr cond : generators.get(i).getInternalIfs()) {
                        if (cond == null) continue;
                        this.visit(cond);
                    }
                    continue;
                }
                this.visit(generators.get(i));
            }
        }
        this.endScope();
        return null;
    }

    @Override
    public Object visitGeneratorExp(GeneratorExp node) throws Exception {
        return this.visitInternalGenerators(node, node.getInternalElt(), node.getInternalGenerators());
    }

    @Override
    public Object visitWith(With node) throws Exception {
        ++this.cur.max_with_count;
        this.traverse(node);
        return null;
    }
}

