/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.delivery;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.repository.Ids;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Metadata(versioned=false, virtual=true, description="Condition for a transition to execute automatically.")
@PublicApiRef
@ShowOnlyPublicApiMembers
public abstract class Condition
extends BaseConfigurationItem {
    @Property(label="Is satisfied", description="Is the transition condition satisfied by an internal or external event.")
    private boolean satisfied = false;
    @Property(label="Satisfied date", description="When was the condition satisfied.")
    private Date satisfiedDate;

    public abstract String getDescription();

    public void validate(Delivery delivery) {
    }

    public boolean isActive() {
        return !this.isSatisfied();
    }

    public Condition withId(String id) {
        this.id = id;
        return this;
    }

    public List<PropertyDescriptor> getInputProperties() {
        return this.getType().getDescriptor().getPropertyDescriptors().stream().filter(pd -> "input".equals(pd.getCategory())).collect(Collectors.toList());
    }

    public List<Condition> markAsSatisfied(String conditionId, Date satisfiedDate) {
        if (this.isActive() && Ids.getName((String)conditionId).equals(Ids.getName((String)this.getId()))) {
            this.satisfied = true;
            this.satisfiedDate = satisfiedDate;
            return Collections.singletonList(this);
        }
        return Collections.emptyList();
    }

    public boolean isLeaf() {
        return true;
    }

    public List<Condition> getAllConditions() {
        return Collections.singletonList(this);
    }

    public List<Condition> getLeafConditions() {
        return Collections.singletonList(this);
    }

    public void reset() {
        this.setSatisfied(false);
        this.setSatisfiedDate(null);
    }

    @PublicApiMember
    public boolean isSatisfied() {
        return this.satisfied;
    }

    public void setSatisfied(boolean satisfied) {
        this.satisfied = satisfied;
    }

    @PublicApiMember
    public Date getSatisfiedDate() {
        return this.satisfiedDate;
    }

    public void setSatisfiedDate(Date satisfiedDate) {
        this.satisfiedDate = satisfiedDate;
    }
}

