/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.dto.AsCodeResponse;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;
import com.xebialabs.xlrelease.ascode.service.DashboardAsCodeService;
import com.xebialabs.xlrelease.ascode.service.ImportResult;
import com.xebialabs.xlrelease.ascode.service.PostCommitAction;
import com.xebialabs.xlrelease.ascode.service.ReferenceSolver;
import com.xebialabs.xlrelease.ascode.utils.DateUtils$;
import com.xebialabs.xlrelease.ascode.utils.ImportContext;
import com.xebialabs.xlrelease.ascode.utils.ImportContext$;
import com.xebialabs.xlrelease.ascode.utils.ImportScope;
import com.xebialabs.xlrelease.ascode.utils.TemplateScope;
import com.xebialabs.xlrelease.ascode.utils.Utils$;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Link;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.events.CreatedFromAsCode;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.events.ReleaseUpdatedFromAsCodeEvent;
import com.xebialabs.xlrelease.domain.events.TemplateVariablesChangedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.versioning.ascode.ImportValidator;
import com.xebialabs.xlrelease.versioning.ascode.ValidationMessage;
import com.xebialabs.xltype.serialization.CiReference;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\t-f\u0001B\r\u001b\u0001\u0015B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!Q\u0005A!A!\u0002\u0013Y\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u000bU\u0003A\u0011\u0001,\t\u000b5\u0004A\u0011\u00018\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!9\u0011\u0011\u000b\u0001\u0005\n\u0005M\u0003bBA/\u0001\u0011%\u0011q\f\u0005\b\u0003W\u0002A\u0011BA7\u0011\u001d\t9\b\u0001C\u0005\u0003sBq!a!\u0001\t\u0013\t)\tC\u0004\u0002\u001c\u0002!I!!(\t\u000f\u0005E\u0007\u0001\"\u0003\u0002T\"9\u0011\u0011\u001d\u0001\u0005\n\u0005\r\bbBA\u007f\u0001\u0011%\u0011q \u0005\b\u0005;\u0001A\u0011\u0002B\u0010\u0011\u001d\u0011\u0019\u0005\u0001C\u0005\u0005\u000bBqAa\u0014\u0001\t\u0013\u0011\t\u0006C\u0004\u0003\\\u0001!IA!\u0018\t\u000f\t\u001d\u0004\u0001\"\u0003\u0003j!9!Q\u0010\u0001\u0005\n\t}$!\u0006+f[Bd\u0017\r^3Bg\u000e{G-Z*feZL7-\u001a\u0006\u00037q\tqa]3sm&\u001cWM\u0003\u0002\u001e=\u00051\u0011m]2pI\u0016T!a\b\u0011\u0002\u0013ad'/\u001a7fCN,'BA\u0011#\u0003%AXMY5bY\u0006\u00147OC\u0001$\u0003\r\u0019w.\\\u0002\u0001'\r\u0001a\u0005\f\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014!B:mMRR'\"A\u0019\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\r\u0018\u0003\u000f1{wmZ5oO\u0006q!/\u001a7fCN,7+\u001a:wS\u000e,\u0007C\u0001\u001c9\u001b\u00059$BA\u000e\u001f\u0013\tItG\u0001\bSK2,\u0017m]3TKJ4\u0018nY3\u0002-\u0011\f7\u000f\u001b2pCJ$\u0017i]\"pI\u0016\u001cVM\u001d<jG\u0016\u0004\"\u0001P\u001f\u000e\u0003iI!A\u0010\u000e\u0003-\u0011\u000b7\u000f\u001b2pCJ$\u0017i]\"pI\u0016\u001cVM\u001d<jG\u0016\fqB]3gKJ,gnY3T_24XM\u001d\t\u0003y\u0005K!A\u0011\u000e\u0003\u001fI+g-\u001a:f]\u000e,7k\u001c7wKJ\f\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z!\t)\u0005*D\u0001G\u0015\t9e$\u0001\u0006sKB|7/\u001b;pefL!!\u0013$\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180A\u0006dS&#7+\u001a:wS\u000e,\u0007C\u0001\u001cM\u0013\tiuGA\u0006DS&#7+\u001a:wS\u000e,\u0017\u0001C3wK:$()^:\u0011\u0005A\u001bV\"A)\u000b\u0005Is\u0012AB3wK:$8/\u0003\u0002U#\n\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\u0002\rqJg.\u001b;?)\u001d9\u0006,\u0017.\\9v\u0003\"\u0001\u0010\u0001\t\u000bQ:\u0001\u0019A\u001b\t\u000bi:\u0001\u0019A\u001e\t\u000b}:\u0001\u0019\u0001!\t\u000b\r;\u0001\u0019\u0001#\t\u000b);\u0001\u0019A&\t\u000b9;\u0001\u0019A()\u0005\u001dy\u0006C\u00011l\u001b\u0005\t'B\u00012d\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003I\u0016\fqAZ1di>\u0014\u0018P\u0003\u0002gO\u0006)!-Z1og*\u0011\u0001.[\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t!.A\u0002pe\u001eL!\u0001\\1\u0003\u0013\u0005+Ho\\<je\u0016$\u0017a\u00029s_\u000e,7o\u001d\u000b\u0004_JT\bC\u0001\u001fq\u0013\t\t(D\u0001\u0007J[B|'\u000f\u001e*fgVdG\u000fC\u0003t\u0011\u0001\u0007A/A\u0004d_:$X\r\u001f;\u0011\u0005UDX\"\u0001<\u000b\u0005]d\u0012!B;uS2\u001c\u0018BA=w\u00055IU\u000e]8si\u000e{g\u000e^3yi\")1\u0010\u0003a\u0001y\u0006AA/Z7qY\u0006$X\rE\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007fz\ta\u0001Z8nC&t\u0017bAA\u0002}\n9!+\u001a7fCN,\u0017\u0001\u00074j]\u0012|%\u000f\u0015:fI&\u001cG\u000fV3na2\fG/Z%egR!\u0011\u0011BA\u0013!!\tY!!\u0007\u0002 \u0005}a\u0002BA\u0007\u0003+\u00012!a\u0004)\u001b\t\t\tBC\u0002\u0002\u0014\u0011\na\u0001\u0010:p_Rt\u0014bAA\fQ\u00051\u0001K]3eK\u001aLA!a\u0007\u0002\u001e\t\u0019Q*\u00199\u000b\u0007\u0005]\u0001\u0006\u0005\u0003\u0002\f\u0005\u0005\u0012\u0002BA\u0012\u0003;\u0011aa\u0015;sS:<\u0007bBA\u0014\u0013\u0001\u0007\u0011\u0011F\u0001\rC2dG+Z7qY\u0006$Xm\u001d\t\t\u0003W\t)$!\u000f\u0002@5\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$A\u0005j[6,H/\u00192mK*\u0019\u00111\u0007\u0015\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00028\u00055\"a\u0002'jgRl\u0015\r\u001d\t\u0004k\u0006m\u0012bAA\u001fm\nY\u0011*\u001c9peR\u001c6m\u001c9f!\u0015\t\t%a\u0013}\u001d\u0011\t\u0019%a\u0012\u000f\t\u0005=\u0011QI\u0005\u0002S%\u0019\u0011\u0011\n\u0015\u0002\u000fA\f7m[1hK&!\u0011QJA(\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005%\u0003&\u0001\u000buK6\u0004H.\u0019;f\u0003\n\u001cx\u000e\\;uKB\u000bG\u000f\u001b\u000b\u0007\u0003?\t)&!\u0017\t\u000f\u0005]#\u00021\u0001\u0002:\u0005)1oY8qK\"9\u00111\f\u0006A\u0002\u0005}\u0011!\u0002;ji2,\u0017\u0001\u00024j]\u0012$b!!\u0019\u0002h\u0005%\u0004\u0003B\u0014\u0002dqL1!!\u001a)\u0005\u0019y\u0005\u000f^5p]\")1o\u0003a\u0001i\")1p\u0003a\u0001y\u000611M]3bi\u0016$ra\\A8\u0003c\n\u0019\bC\u0003t\u0019\u0001\u0007A\u000fC\u0003|\u0019\u0001\u0007A\u0010C\u0004\u0002v1\u0001\r!a\b\u0002\u0005%$\u0017AB;qI\u0006$X\rF\u0004p\u0003w\ni(!!\t\u000bMl\u0001\u0019\u0001;\t\r\u0005}T\u00021\u0001}\u0003!)\u00070[:uS:<\u0007\"B>\u000e\u0001\u0004a\u0018\u0001\u0003<bY&$\u0017\r^3\u0015\r\u0005\u001d\u0015qSAM!\u0019\t\t%a\u0013\u0002\nB!\u00111RAJ\u001b\t\tiIC\u0002\u001e\u0003\u001fS1!!%\u001f\u0003)1XM]:j_:LgnZ\u0005\u0005\u0003+\u000biIA\tWC2LG-\u0019;j_:lUm]:bO\u0016DQa\u001d\bA\u0002QDQa\u001f\bA\u0002q\f!bZ3oKJ\fG/Z%e+\u0011\ty*!+\u0015\r\u0005}\u0011\u0011UAg\u0011\u001d\t\u0019k\u0004a\u0001\u0003K\u000b!aY5\u0011\t\u0005\u001d\u0016\u0011\u0016\u0007\u0001\t\u001d\tYk\u0004b\u0001\u0003[\u0013\u0011\u0001V\t\u0005\u0003_\u000b)\fE\u0002(\u0003cK1!a-)\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a.\u0002J6\u0011\u0011\u0011\u0018\u0006\u0005\u0003w\u000bi,A\u0002vI6TA!a0\u0002B\u0006\u0019\u0011\r]5\u000b\t\u0005\r\u0017QY\u0001\u0007a2,x-\u001b8\u000b\u0007\u0005\u001d\u0007%\u0001\u0005eKBdw._5u\u0013\u0011\tY-!/\u0003#\r{gNZ5hkJ\fG/[8o\u0013R,W\u000eC\u0004\u0002P>\u0001\r!a\b\u0002\u0011A\f'/\u001a8u\u0013\u0012\fA\u0003]8qk2\fG/\u001a+f[Bd\u0017\r^3ECR\fG\u0003CAk\u00037\fi.a8\u0011\u0007\u001d\n9.C\u0002\u0002Z\"\u0012A!\u00168ji\")1\u000f\u0005a\u0001i\")1\u0010\u0005a\u0001y\"9\u0011Q\u000f\tA\u0002\u0005}\u0011!\u00059paVd\u0017\r^3QQ\u0006\u001cX\rR1uCRa\u0011Q[As\u0003_\f\t0!>\u0002|\"9\u0011q]\tA\u0002\u0005%\u0018!\u00029iCN,\u0007cA?\u0002l&\u0019\u0011Q\u001e@\u0003\u000bAC\u0017m]3\t\u000bm\f\u0002\u0019\u0001?\t\u000f\u0005M\u0018\u00031\u0001\u0002 \u0005Aam\u001c7eKJLE\rC\u0004\u0002xF\u0001\r!!?\u0002\t!|W.\u001a\t\u0006O\u0005\r\u0014q\u0004\u0005\u0006gF\u0001\r\u0001^\u0001\u0011a>\u0004X\u000f\\1uKR\u000b7o\u001b#bi\u0006$b\"!6\u0003\u0002\t-!Q\u0003B\f\u00053\u0011Y\u0002C\u0004\u0003\u0004I\u0001\rA!\u0002\u0002\tQ\f7o\u001b\t\u0004{\n\u001d\u0011b\u0001B\u0005}\n!A+Y:l\u0011\u001d\u0011iA\u0005a\u0001\u0005\u001f\t\u0011bY8oi\u0006Lg.\u001a:\u0011\u0007u\u0014\t\"C\u0002\u0003\u0014y\u0014Q\u0002V1tW\u000e{g\u000e^1j]\u0016\u0014\b\"B>\u0013\u0001\u0004a\bbBAz%\u0001\u0007\u0011q\u0004\u0005\b\u0003o\u0014\u0002\u0019AA}\u0011\u0015\u0019(\u00031\u0001u\u0003U\u0001x\u000e];mCR,Wk]3s\u0013:\u0004X\u000f\u001e+bg.$b!!6\u0003\"\t%\u0002b\u0002B\u0002'\u0001\u0007!1\u0005\t\u0004{\n\u0015\u0012b\u0001B\u0014}\niQk]3s\u0013:\u0004X\u000f\u001e+bg.DqAa\u000b\u0014\u0001\u0004\u0011i#A\u0005wCJL\u0017M\u00197fgB1!q\u0006B\u001b\u0005si!A!\r\u000b\t\tM\u0012\u0011G\u0001\b[V$\u0018M\u00197f\u0013\u0011\u00119D!\r\u0003\r\t+hMZ3s!\u0011\u0011YDa\u0010\u000e\u0005\tu\"b\u0001B\u0016}&!!\u0011\tB\u001f\u0005!1\u0016M]5bE2,\u0017\u0001\u00079paVd\u0017\r^3DkN$x.\\*de&\u0004H\u000fV1tWR!\u0011Q\u001bB$\u0011\u001d\u0011\u0019\u0001\u0006a\u0001\u0005\u0013\u00022! B&\u0013\r\u0011iE \u0002\u0011\u0007V\u001cHo\\7TGJL\u0007\u000f\u001e+bg.\f\u0011\u0004]8qk2\fG/Z\"sK\u0006$XMU3mK\u0006\u001cX\rV1tWR!\u0011Q\u001bB*\u0011\u001d\u0011\u0019!\u0006a\u0001\u0005+\u00022! B,\u0013\r\u0011IF \u0002\u0012\u0007J,\u0017\r^3SK2,\u0017m]3UCN\\\u0017\u0001\u00059paVd\u0017\r^3HCR,G+Y:l)\u0011\t)Na\u0018\t\u000f\t\ra\u00031\u0001\u0003bA\u0019QPa\u0019\n\u0007\t\u0015dP\u0001\u0005HCR,G+Y:l\u0003E\u0001x\u000e];mCR,G+Y:l\u000fJ|W\u000f\u001d\u000b\r\u0003+\u0014YG!\u001e\u0003x\te$1\u0010\u0005\b\u0005[:\u0002\u0019\u0001B8\u0003\u00159'o\\;q!\ri(\u0011O\u0005\u0004\u0005gr(!\u0003+bg.<%o\\;q\u0011\u0015Yx\u00031\u0001}\u0011\u001d\t\u0019p\u0006a\u0001\u0003?Aq!a>\u0018\u0001\u0004\tI\u0010C\u0003t/\u0001\u0007A/\u0001\bqe>\u001cWm]:TG6$\u0015\r^1\u0015\r\u0005U'\u0011\u0011BN\u0011\u001d\u0011\u0019\t\u0007a\u0001\u0005\u000b\u000bA\u0001Z1uCB)q%a\u0019\u0003\bB!!\u0011\u0012BL\u001b\t\u0011YI\u0003\u0003\u0003\u000e\n=\u0015a\u00013u_*!!\u0011\u0013BJ\u0003\r\u0019wn\u0019\u0006\u0004\u0005+\u0003\u0013A\u0003=ma2\fGOZ8s[&!!\u0011\u0014BF\u0005M\u00196)\u0014+sC\u000e,\u0017MY5mSRLH)\u0019;b\u0011\u0015Y\b\u00041\u0001}Q\r\u0001!q\u0014\t\u0005\u0005C\u00139+\u0004\u0002\u0003$*\u0019!QU4\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0003*\n\r&aB*feZL7-\u001a")
public class TemplateAsCodeService
implements Logging {
    private final ReleaseService releaseService;
    private final DashboardAsCodeService dashboardAsCodeService;
    private final ReferenceSolver referenceSolver;
    private final ReleaseRepository releaseRepository;
    private final CiIdService ciIdService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TemplateAsCodeService templateAsCodeService = this;
        synchronized (templateAsCodeService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ImportResult process(ImportContext context, Release template) {
        ImportResult importResult;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(36).append("Processing template: ").append(template.toString()).append(" with metadata ").append(context.metadata().toString()).toString());
        if (!template.getReleaseTriggers().isEmpty()) {
            throw new AsCodeException("Templates with release triggers are no longer supported.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        this.referenceSolver.resolveReferences((ConfigurationItem)template, context.references(), (String)context.scope().getFolderId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Option<Release> option = this.find(context, template);
        if (option instanceof Some) {
            Some some = (Some)option;
            Release existing = (Release)some.value();
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(19).append("Updating template: ").append(existing.toString()).toString());
            importResult = this.update(context, existing, template);
        } else if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(19).append("Creating template: ").append(template.toString()).toString());
            String id = (String)context.templateIds().getOrElse((Object)this.templateAbsolutePath(context.scope(), template.getTitle()), (Function0 & Serializable)() -> this.generateId(template, (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> Ids.ROOT_FOLDER_ID)));
            importResult = this.create(context, template, id);
        } else {
            throw new MatchError(option);
        }
        return importResult;
    }

    public Map<String, String> findOrPredictTemplateIds(ListMap<ImportScope, List<Release>> allTemplates) {
        return (Map)allTemplates.toList().foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Map map;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    map = (Map)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            ImportScope scope = (ImportScope)tuple2._1();
            List templates = (List)tuple2._2();
            ImportContext context = new ImportContext(scope, (Map<String, String>)Predef$.MODULE$.Map().empty(), (List<CiReference>)package$.MODULE$.List().empty(), (Option<SCMTraceabilityData>)None$.MODULE$, ImportContext$.MODULE$.apply$default$5(), ImportContext$.MODULE$.apply$default$6());
            Map map2 = (Map)map.$plus$plus((IterableOnce)templates.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$2, x1$2) -> {
                String string;
                Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Map idMap = (Map)tuple2._1();
                Release template = (Release)tuple2._2();
                Option<Release> option = this.find(context, template);
                if (None$.MODULE$.equals(option)) {
                    string = this.generateId(template, (String)scope.getFolderId().getOrElse((Function0 & Serializable)() -> Ids.ROOT_FOLDER_ID));
                } else {
                    if (!(option instanceof Some)) throw new MatchError(option);
                    Some some = (Some)option;
                    Release existing = (Release)some.value();
                    string = existing.getId();
                }
                String id = string;
                return (Map)idMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.templateAbsolutePath(scope, template.getTitle())), (Object)id));
            }));
            return map2;
        });
    }

    private String templateAbsolutePath(ImportScope scope, String title) {
        String string;
        Option<String> option = scope.getFolderPath();
        if (None$.MODULE$.equals(option)) {
            string = title;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            string = Utils$.MODULE$.joinPaths((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{path, title}))));
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private Option<Release> find(ImportContext context, Release template) {
        List matches = CollectionConverters$.MODULE$.ListHasAsScala(this.releaseService.findTemplatesByTitle((String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/"), template.getTitle(), 0, 2, 1)).asScala().toList();
        if (matches.length() > 1) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(51).append("There are multiple templates named [").append(template.getTitle()).append("] ").append(context.scope().description()).append(", those are: ").append(matches.toString()).toString());
            throw new AsCodeException(new StringBuilder(72).append("Multiple templates are named [").append(template.getTitle()).append("] ").append(context.scope().description()).append(". Can not determine which one to update.").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        return matches.headOption();
    }

    private ImportResult create(ImportContext context, Release template, String id) {
        this.populateTemplateData(context, template, id);
        List<ValidationMessage> messages = this.validate(context, template);
        Release created = this.releaseRepository.create(template, null);
        this.processScmData(context.scmData(), created);
        return new ImportResult((List<AsCodeResponse.ChangedIds>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AsCodeResponse.ChangedIds[]{AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withCreated(created.getId())}))), (Seq<PostCommitAction>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PostCommitAction[]{() -> $this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(created, (ReleaseCreationSource)new CreatedFromAsCode(context.scmData())))}))), (Map<String, Map<Type, AsCodeResponse.ChangedIds>>)Predef$.MODULE$.Map().empty(), messages);
    }

    private ImportResult update(ImportContext context, Release existing, Release template) {
        this.populateTemplateData(context, template, existing.getId());
        template.setCiUid(existing.getCiUid());
        List<ValidationMessage> messages = this.validate(context, template);
        Release updated = this.releaseRepository.replace(existing, template);
        this.processScmData(context.scmData(), updated);
        java.util.List templateVars = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(updated.getVariables()).asScala().withFilter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.getShowOnReleaseStart())).map((Function1 & Serializable)v -> (Variable)CiCloneHelper.cloneCi((ConfigurationItem)v))).asJava();
        return new ImportResult((List<AsCodeResponse.ChangedIds>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AsCodeResponse.ChangedIds[]{AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withUpdated(updated.getId())}))), (Seq<PostCommitAction>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PostCommitAction[]{() -> $this.eventBus.publish((XLReleaseEvent)new ReleaseUpdatedFromAsCodeEvent(updated, context.scmData())), () -> $this.eventBus.publish((XLReleaseEvent)new TemplateVariablesChangedEvent(updated.getId(), templateVars))}))), (Map<String, Map<Type, AsCodeResponse.ChangedIds>>)Predef$.MODULE$.Map().empty(), messages);
    }

    private List<ValidationMessage> validate(ImportContext context, Release template) {
        List list;
        Option<ImportValidator> option = context.validator();
        if (option instanceof Some) {
            Some some = (Some)option;
            ImportValidator validator = (ImportValidator)some.value();
            list = validator.validateCi((ConfigurationItem)template, context.getFolderInfo()).toList();
        } else if (None$.MODULE$.equals(option)) {
            list = package$.MODULE$.List().empty();
        } else {
            throw new MatchError(option);
        }
        return list;
    }

    private <T extends ConfigurationItem> String generateId(T ci, String parentId) {
        return this.ciIdService.getUniqueId(ci.getType(), parentId);
    }

    private void populateTemplateData(ImportContext context, Release template, String id) {
        Option<String> home = context.scope().getMetadataHome();
        template.setId(id);
        template.setStatus(ReleaseStatus.TEMPLATE);
        if (template.getScheduledStartDate() == null) {
            template.setScheduledStartDate(new Date());
        }
        if (template.getDueDate() == null) {
            if (template.getPlannedDuration() == null) {
                Date nextHour = DateUtils$.MODULE$.addHoursToDate(template.getScheduledStartDate(), 1);
                template.setDueDate(nextHour);
            } else {
                template.setDueDate(DateUtils$.MODULE$.addHoursToDate(template.getScheduledStartDate(), DateUtils$.MODULE$.secondsToHours(Predef$.MODULE$.Integer2int(template.getPlannedDuration()))));
            }
        }
        CollectionConverters$.MODULE$.ListHasAsScala(template.getVariables()).asScala().foreach((Function1 & Serializable)variable -> {
            VariablePersistenceHelper$.MODULE$.fixUpReleaseVariable(variable, template.getId(), this.ciIdService);
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.ListHasAsScala(template.getPhases()).asScala().foreach((Function1 & Serializable)phase -> {
            this.populatePhaseData(phase, template, (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/"), (Option<String>)home, context);
            return BoxedUnit.UNIT;
        });
        ImportContext templateScopedContext = context.copy(new TemplateScope(template.getId(), template.getTitle(), context.scope()), context.copy$default$2(), context.copy$default$3(), context.copy$default$4(), context.copy$default$5(), context.copy$default$6());
        template.getExtensions().forEach(x0$1 -> {
            ReleaseExtension releaseExtension = x0$1;
            if (!(releaseExtension instanceof Dashboard)) {
                throw new MatchError((Object)releaseExtension);
            }
            Dashboard dashboard = (Dashboard)releaseExtension;
            $this.dashboardAsCodeService.initializeTemplateDashboard(templateScopedContext, dashboard);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    private void populatePhaseData(Phase phase, Release template, String folderId, Option<String> home, ImportContext context) {
        phase.setId(this.generateId(phase, template.getId()));
        phase.setStatus(PhaseStatus.PLANNED);
        phase.setRelease(template);
        CollectionConverters$.MODULE$.ListHasAsScala(phase.getTasks()).asScala().foreach((Function1 & Serializable)task -> {
            this.populateTaskData(task, (TaskContainer)phase, template, folderId, (Option<String>)home, context);
            return BoxedUnit.UNIT;
        });
    }

    private void populateTaskData(Task task, TaskContainer container, Release template, String folderId, Option<String> home, ImportContext context) {
        task.setId(this.generateId(task, container.getId()));
        task.setStatus(TaskStatus.PLANNED);
        task.setContainer(container);
        CollectionConverters$.MODULE$.ListHasAsScala(task.getFacets()).asScala().foreach((Function1 & Serializable)facet -> {
            TemplateAsCodeService.$anonfun$populateTaskData$1(this, task, folderId, home, facet);
            return BoxedUnit.UNIT;
        });
        this.referenceSolver.resolveStringReference((ConfigurationItem)task, folderId, home, context.templateIds());
        Task task2 = task;
        if (task2 instanceof CustomScriptTask) {
            CustomScriptTask customScriptTask = (CustomScriptTask)task2;
            this.populateCustomScriptTask(customScriptTask);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (task2 instanceof CreateReleaseTask) {
            CreateReleaseTask createReleaseTask = (CreateReleaseTask)task2;
            this.populateCreateReleaseTask(createReleaseTask);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (task2 instanceof GateTask) {
            GateTask gateTask = (GateTask)task2;
            this.populateGateTask(gateTask);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (task2 instanceof TaskGroup) {
            TaskGroup taskGroup = (TaskGroup)task2;
            this.populateTaskGroup(taskGroup, template, folderId, home, context);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (task2 instanceof UserInputTask) {
            UserInputTask userInputTask = (UserInputTask)task2;
            this.populateUserInputTask(userInputTask, (Buffer<Variable>)CollectionConverters$.MODULE$.ListHasAsScala(template.getVariables()).asScala());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void populateUserInputTask(UserInputTask task, Buffer<Variable> variables) {
        Map varMap = ((IterableOnceOps)variables.map((Function1 & Serializable)variable -> new Tuple2((Object)variable.getKey(), variable))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Buffer usedVars = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(task.getVariables()).asScala().filter((Function1 & Serializable)taskVar -> BoxesRunTime.boxToBoolean((boolean)varMap.contains((Object)taskVar.getKey())))).map((Function1 & Serializable)taskVar -> (Variable)varMap.apply((Object)taskVar.getKey()));
        task.setVariables(CollectionConverters$.MODULE$.BufferHasAsJava(usedVars).asJava());
    }

    private void populateCustomScriptTask(CustomScriptTask task) {
        PythonScript pythonScript = task.getPythonScript();
        pythonScript.setId(new StringBuilder(13).append(task.getId()).append("/").append("PythonScript").toString());
        pythonScript.setCustomScriptTask(task);
    }

    private void populateCreateReleaseTask(CreateReleaseTask task) {
        CollectionConverters$.MODULE$.ListHasAsScala(task.getTemplateVariables()).asScala().foreach((Function1 & Serializable)variable -> {
            variable.setId(this.generateId(variable, task.getId()));
            return BoxedUnit.UNIT;
        });
    }

    private void populateGateTask(GateTask task) {
        CollectionConverters$.MODULE$.ListHasAsScala(task.getConditions()).asScala().foreach((Function1 & Serializable)condition -> {
            condition.setId(this.ciIdService.getUniqueId(condition.getType(), task.getId()));
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.ListHasAsScala(task.getDependencies()).asScala().foreach((Function1 & Serializable)dep -> {
            TemplateAsCodeService.$anonfun$populateGateTask$2(this, task, dep);
            return BoxedUnit.UNIT;
        });
    }

    private void populateTaskGroup(TaskGroup group, Release template, String folderId, Option<String> home, ImportContext context) {
        CollectionConverters$.MODULE$.ListHasAsScala(group.getTasks()).asScala().foreach((Function1 & Serializable)task -> {
            this.populateTaskData(task, (TaskContainer)group, template, folderId, (Option<String>)home, context);
            return BoxedUnit.UNIT;
        });
        TaskGroup taskGroup = group;
        if (taskGroup instanceof ParallelGroup) {
            BoxedUnit boxedUnit;
            ParallelGroup parallelGroup = (ParallelGroup)taskGroup;
            if (!parallelGroup.getLinks().isEmpty()) {
                Map nameToTask = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(parallelGroup.getTasks()).asScala().map((Function1 & Serializable)task -> new Tuple2((Object)task.getTitle(), task))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                CollectionConverters$.MODULE$.SetHasAsScala(parallelGroup.getLinks()).asScala().foreach((Function1 & Serializable)link -> {
                    TemplateAsCodeService.$anonfun$populateTaskGroup$3(this, group, nameToTask, link);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void processScmData(Option<SCMTraceabilityData> data, Release template) {
        data.filterNot((Function1 & Serializable)scmData -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.isSCMDataEmpty(scmData))).foreach((Function1 & Serializable)x$2 -> $this.releaseService.createSCMData(template.getId(), x$2));
    }

    public static final /* synthetic */ void $anonfun$populateTaskData$1(TemplateAsCodeService $this, Task task$1, String folderId$2, Option home$3, Facet facet) {
        facet.setTargetId(task$1.getId());
        facet.setId($this.generateId(facet, ""));
        $this.referenceSolver.resolveStringReference((ConfigurationItem)facet, folderId$2, (Option<String>)home$3, $this.referenceSolver.resolveStringReference$default$4());
    }

    public static final /* synthetic */ void $anonfun$populateGateTask$2(TemplateAsCodeService $this, GateTask task$3, Dependency dep) {
        if (!VariableHelper$.MODULE$.containsVariables(dep.getTargetId())) {
            throw new AsCodeException("Gate tasks with hardcoded release dependencies cannot be applied, change the dependency to using a variable instead.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        dep.setId($this.ciIdService.getUniqueId(dep.getType(), task$3.getId()));
    }

    public static final /* synthetic */ void $anonfun$populateTaskGroup$3(TemplateAsCodeService $this, TaskGroup group$1, Map nameToTask$1, Link link) {
        link.setId($this.generateId(link, group$1.getId()));
        link.setSource((Task)nameToTask$1.apply((Object)link.getSource().getTitle()));
        link.setTarget((Task)nameToTask$1.apply((Object)link.getTarget().getTitle()));
    }

    @Autowired
    public TemplateAsCodeService(ReleaseService releaseService, DashboardAsCodeService dashboardAsCodeService, ReferenceSolver referenceSolver, ReleaseRepository releaseRepository, CiIdService ciIdService, XLReleaseEventBus eventBus) {
        this.releaseService = releaseService;
        this.dashboardAsCodeService = dashboardAsCodeService;
        this.referenceSolver = referenceSolver;
        this.releaseRepository = releaseRepository;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

