/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement;

import java.util.Objects;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.PurgeObjectType;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.Index;

public class PurgeStatement
implements Statement {
    private final PurgeObjectType purgeObjectType;
    private final Object object;
    private String userName;

    public PurgeStatement(Table table) {
        this.purgeObjectType = PurgeObjectType.TABLE;
        this.object = Objects.requireNonNull(table, "The TABLE of the PURGE TABLE statement must not be null.");
    }

    public PurgeStatement(Index index) {
        this.purgeObjectType = PurgeObjectType.INDEX;
        this.object = Objects.requireNonNull(index, "The INDEX of the PURGE INDEX statement must not be null.");
    }

    public PurgeStatement(PurgeObjectType purgeObjectType) {
        this.purgeObjectType = purgeObjectType;
        this.object = null;
    }

    public PurgeStatement(PurgeObjectType purgeObjectType, String string, String string2) {
        this.purgeObjectType = purgeObjectType;
        this.object = Objects.requireNonNull(string, "The TABLESPACE NAME of the PURGE TABLESPACE statement must not be null.");
        this.userName = string2;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public StringBuilder appendTo(StringBuilder stringBuilder) {
        stringBuilder.append("PURGE ");
        switch (this.purgeObjectType) {
            case RECYCLEBIN: 
            case DBA_RECYCLEBIN: {
                stringBuilder.append((Object)this.purgeObjectType);
                break;
            }
            case TABLE: 
            case INDEX: {
                stringBuilder.append((Object)this.purgeObjectType);
                if (this.object == null) break;
                stringBuilder.append(" ").append(this.object);
                break;
            }
            case TABLESPACE: {
                stringBuilder.append((Object)this.purgeObjectType);
                if (this.object != null) {
                    stringBuilder.append(" ").append(this.object);
                }
                if (this.userName == null || this.userName.length() <= 0) break;
                stringBuilder.append(" USER ").append(this.userName);
            }
        }
        return stringBuilder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public PurgeObjectType getPurgeObjectType() {
        return this.purgeObjectType;
    }

    public Object getObject() {
        return this.object;
    }
}

