package com.xebialabs.xlrelease.support.cache.caffeine

import com.github.benmanes.caffeine.cache.{Cache, CacheLoader, LoadingCache}

import java.util.Collections
import java.util.concurrent.CompletableFuture
import java.{lang, util}
import scala.jdk.CollectionConverters._

class LoadingCaffeineCacheDelegate[K, V](name: String, cache: Cache[K, V],
                                         regexSupport: Boolean,
                                         _enabled: Boolean,
                                         cacheLoader: CacheLoader[K, V])
  extends CaffeineCacheDelegate[K, V](name, cache, regexSupport, _enabled) with LoadingCache[K, V] {

  private val NOT_A_LOADING_CACHE = "Cache is not a LoadingCache"

  override def get(key: K): V = {
    cache match {
      case loadingCache: LoadingCache[K, V] if enabled => loadingCache.get(key)
      case _: LoadingCache[K, V] if !enabled => cacheLoader.load(key)
      case _ => throw new UnsupportedOperationException(NOT_A_LOADING_CACHE)
    }
  }

  override def getAll(keys: lang.Iterable[_ <: K]): util.Map[K, V] = {
    cache match {
      case loadingCache: LoadingCache[K, V] if enabled => loadingCache.getAll(keys)
      case _: LoadingCache[K, V] if !enabled => new util.HashMap[K, V](keys.asScala.map(key => (key, cacheLoader.load(key))).toMap.asJava)
      case _ => throw new UnsupportedOperationException(NOT_A_LOADING_CACHE)
    }
  }

  override def refresh(key: K): CompletableFuture[V] = {
    cache match {
      case loadingCache: LoadingCache[K, V] if enabled => loadingCache.refresh(key)
      case _: LoadingCache[K, V] if !enabled => CompletableFuture.completedFuture(null.asInstanceOf[V])
      case _ => throw new UnsupportedOperationException(NOT_A_LOADING_CACHE)
    }
  }

  override def refreshAll(keys: lang.Iterable[_ <: K]): CompletableFuture[util.Map[K, V]] = {
    cache match {
      case loadingCache: LoadingCache[K, V] if enabled => loadingCache.refreshAll(keys)
      case _: LoadingCache[K, V] if !enabled => CompletableFuture.completedFuture(Collections.emptyMap())
      case _ => throw new UnsupportedOperationException(NOT_A_LOADING_CACHE)
    }
  }
}
