package com.xebialabs.xlrelease

import org.scalatest.{BeforeAndAfterAll, BeforeAndAfterEach, Suite}

import java.security.Policy

trait SecurityFixture extends BeforeAndAfterEach with BeforeAndAfterAll {
  this: Suite =>

  override protected def beforeAll(): Unit = {
    super.beforeAll()
    System.setProperty("java.security.policy", classOf[SecurityFixture].getResource("/xl-release-test.policy").toExternalForm)
    Policy.getPolicy.refresh()
  }

  override protected def afterAll(): Unit = {
    System.clearProperty("java.security.policy")
    Policy.getPolicy.refresh()
  }

  override protected def beforeEach(): Unit = {
    super.beforeEach()
    System.setSecurityManager(new SecurityManager)
  }

  override protected def afterEach(): Unit = {
    System.setSecurityManager(null)
    super.afterEach()
  }
}
