package com.xebialabs.xlrelease.assertions;

import org.assertj.core.api.AbstractAssert;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.events.XLReleaseOperation;

import static com.xebialabs.xlrelease.assertions.XLReleaseAssertions.assertThat;

public class ChangesAssertion extends AbstractAssert<ChangesAssertion, Changes> {
    protected ChangesAssertion(Changes actual) {
        super(actual, ChangesAssertion.class);
    }

    public ChangesAssertion containsOnlyUpdatedItems(ConfigurationItem... items) {
        assertThat(actual.getUpdatedItems()).containsOnly(items);
        return this;
    }

    public ChangesAssertion containsOnlyRemovedIds(String... ids) {
        assertThat(actual.getRemovedIds()).containsOnly(ids);
        return this;
    }

    public ChangesAssertion containsExactlyOperations(XLReleaseOperation... operations) {
        assertThat(actual.getOperations()).containsExactly(operations);
        return this;
    }

}
