package com.xebialabs.xlrelease.assertions;

import java.util.List;

import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.service.ExecutePreconditionAction;

import static java.util.stream.Collectors.toList;
import static org.assertj.core.api.Assertions.assertThat;

public class PreconditionsAssertions {
    public static void verifyPreconditionEvaluated(Changes changes) {
        List<Class<?>> actionTypes = changes.getPostActions().stream().map(Object::getClass).collect(toList());
        assertThat(actionTypes).contains(ExecutePreconditionAction.class);
    }

    public static void verifyPreconditionNotEvaluated(Changes changes) {
        List<Class<?>> actionTypes = changes.getPostActions().stream().map(Object::getClass).collect(toList());
        assertThat(actionTypes).doesNotContain(ExecutePreconditionAction.class);
    }
}
