package com.xebialabs.xlrelease.logback;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;

/**
 * Can be used like this:
 *
 * <pre>{@code
 * <configuration>
 *     <conversionRule conversionWord="pid"
 *                     converterClass="com.xebialabs.xlrelease.logback.ProcessIdConverter" />
 *
 *     <appender name="FILE" class="ch.qos.logback.core.FileAppender">
 *         <file>build/log/xl-release.log</file>
 *         <encoder>
 *             <pattern>$-6pid %d{yyyy-MM-dd HH:mm:ss.SSS} [%thread] {%mdc} %-5level %logger{36} - %msg%n</pattern>
 *         </encoder>
 *     </appender>
 *     <!-- .... -->
 *  </configuration>
 *
 * }</pre>
 *
 * see http://logback.qos.ch/manual/layouts.html
 */
public class ProcessIdConverter extends ClassicConverter {
    private long pid = ProcessHandle.current().pid();

    @Override
    public String convert(final ILoggingEvent event) {
        return Long.toString(pid);
    }
}
