package com.xebialabs.xlrelease.builder;

import java.util.Date;

import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.utils.CommentServiceHelper;

public class CommentBuilder {
    private String id;
    private String text;
    private String author;
    private Date date;
    private Date creationDate;
    private int maxCommentSize = -1;

    private CommentBuilder() {
    }

    public static CommentBuilder newComment() {
        return new CommentBuilder();
    }

    public CommentBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public CommentBuilder withText(String text) {
        this.text = text;
        return this;
    }

    public CommentBuilder withAuthor(String author) {
        this.author = author;
        return this;
    }

    public CommentBuilder withDate(Date date) {
        this.date = date;
        return this;
    }

    public CommentBuilder withCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public CommentBuilder withLimit(final int maxCommentSize) {
        this.maxCommentSize = maxCommentSize;
        return this;
    }

    public Comment build() {
        Comment comment = new Comment().getType().getDescriptor().newInstance(id);
        if (null != text) {
            if (maxCommentSize >= 0) {
                CommentServiceHelper.appendCommentText(comment, text, maxCommentSize, "", "");
            }
            comment.setText(text);
        }
        comment.setAuthor(author);
        comment.setDate(date);
        comment.setCreationDate(creationDate);

        return comment;
    }
}
