package com.xebialabs.xlrelease.builder;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.RemoteScriptExecution;

import java.util.Map;

import static com.google.common.collect.Maps.newHashMap;

public class RemoteScriptExecutionBuilder {

    private String type;

    private Map<String, Object> inputParameters = newHashMap();

    private Map<String, Object> outputProperties = newHashMap();

    private String statusLine;

    private boolean keepPreviousOutputPropertiesOnRetry;

    public RemoteScriptExecutionBuilder(String type) {
        this.type = type;
    }

    public RemoteScriptExecutionBuilder withInputParameters(Map<String, Object> inputParameters) {
        this.inputParameters = inputParameters;
        return this;
    }

    public RemoteScriptExecutionBuilder withOutputProperties(Map<String, Object> outputProperties) {
        this.outputProperties = outputProperties;
        return this;
    }

    public RemoteScriptExecutionBuilder withStatusLine(String statusLine) {
        this.statusLine = statusLine;
        return this;
    }

    public RemoteScriptExecutionBuilder withKeepPreviousOutputPropertiesOnRetry(final boolean keepPreviousOutputPropertiesOnRetry) {
        this.keepPreviousOutputPropertiesOnRetry = keepPreviousOutputPropertiesOnRetry;
        return this;
    }

    public RemoteScriptExecution build() {
        RemoteScriptExecution execution = Type.valueOf(type).getDescriptor().newInstance(null);
        execution.setStatusLine(statusLine);
        for (Map.Entry<String, Object> entry : inputParameters.entrySet()) {
            execution.setProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : outputProperties.entrySet()) {
            execution.setProperty(entry.getKey(), entry.getValue());
        }
        return execution;
    }
}
