package com.xebialabs.xlrelease.builder;

import java.util.List;

import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.variables.Variable;

import static com.google.common.collect.Lists.newArrayList;

public class UserInputTaskBuilder extends TaskBuilder<UserInputTask, UserInputTaskBuilder> {
    private List<Variable> variables;

    public UserInputTaskBuilder withVariables(List<Variable> variables) {
        this.variables = variables;
        return this;
    }

    public UserInputTaskBuilder withVariables(Variable... variables) {
        return withVariables(newArrayList(variables));
    }

    @Override
    protected void setFields(UserInputTask task) {
        super.setFields(task);
        task.setVariables(variables);
    }

    @Override
    public UserInputTask build() {
        UserInputTask task = new UserInputTask().getType().getDescriptor().newInstance("dummy");
        setFields(task);
        return task;
    }
}
