package com.xebialabs.xlrelease.domain.utils;

import java.util.function.Supplier;

import com.xebialabs.xlrelease.domain.Release;

import static com.xebialabs.deployit.checks.Checks.checkNotNull;

public class OptionallyDecoratedReleaseSupplier {
    private String releaseId;
    private Supplier<Release> decoratedCache;
    private Supplier<Release> decoratedSupplier;
    private Supplier<Release> nonDecoratedSupplier;

    public OptionallyDecoratedReleaseSupplier(final String releaseId, final Supplier<Release> decoratedCache, final Supplier<Release> decoratedSupplier, final Supplier<Release> nonDecoratedSupplier) {
        this.releaseId = releaseId;
        this.decoratedCache = decoratedCache;
        this.decoratedSupplier = decoratedSupplier;
        this.nonDecoratedSupplier = nonDecoratedSupplier;
    }

    public Release getDecorated() {
        Release release = decoratedCache.get();
        if (release == null) {
            release = decoratedSupplier.get();
        }
        return release;
    }

    public Release getNonDecorated() {
        Release release = decoratedCache.get();
        if (release == null) {
            release = nonDecoratedSupplier.get();
        }
        return release;
    }

    public static OptionallyDecoratedReleaseSupplier ofDecoratedRelease(Release release) {
        checkNotNull(release, "Release");
        return new OptionallyDecoratedReleaseSupplier(release.getId(), () -> release, null, null);
    }

    @Override
    public String toString() {
        return "OptionallyDecoratedReleaseSupplier{" +
                "releaseId='" + releaseId + '\'' +
                '}';
    }
}
