package com.xebialabs.xlrelease.serialization.json.repository

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.services.Repository
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem

import java.util
import scala.jdk.CollectionConverters._

class InMemoryRepository(cis: util.Map[String, ConfigurationItem]) extends Repository {

  override def exists(id: String): Boolean = cis.containsKey(id)

  @SuppressWarnings(Array("unchecked"))
  override def read[T <: ConfigurationItem](id: String): T = cis.get(id).asInstanceOf[T]

  override def read[T <: ConfigurationItem](ids: util.List[String], depth: Integer): util.List[T] = {
    ids.asScala.map(this.read[T]).filter(_ != null).asJava
  }

  override def create[T <: ConfigurationItem](entity: T*): Unit = {
    throw new RuntimeException("Not supported in InMemoryRepository")
  }

  override def update[T <: ConfigurationItem](entity: T*): Unit = {
    throw new RuntimeException("Not supported in InMemoryRepository")
  }

  override def createOrUpdate[T <: ConfigurationItem](entity: T*): Unit = {
    throw new RuntimeException("Not supported in InMemoryRepository")
  }

  override def delete(id: String*): Unit = {
    throw new RuntimeException("Not supported in InMemoryRepository")
  }

  override def move(id: String, newId: String): Unit = {
    throw new RuntimeException("Not supported in InMemoryRepository")
  }

  override def rename(id: String, newName: String): Unit = {
    throw new RuntimeException("Not supported in InMemoryRepository")
  }

  override def search[T <: ConfigurationItem](`type`: Type) = throw new RuntimeException("Not supported in InMemoryRepository")

  override def search[T <: ConfigurationItem](`type`: Type, parent: String) = throw new RuntimeException("Not supported in InMemoryRepository")


}
