/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.serialization.json.jackson;

import com.xebialabs.xlrelease.repository.IdType;
import org.springframework.util.StringUtils;

public interface DomainIdSerialization {
    private static boolean hasVariableSyntax(String rawValue) {
        boolean hasText = StringUtils.hasText((String)rawValue);
        if (hasText) {
            String trimmedValue = rawValue.trim();
            return trimmedValue.startsWith("${") && trimmedValue.endsWith("}");
        }
        return false;
    }

    default public String toViewId(String value) {
        if (StringUtils.hasText((String)value)) {
            if (DomainIdSerialization.hasVariableSyntax(value)) {
                return value;
            }
            return IdType.DOMAIN.convertToViewId(value);
        }
        return value;
    }

    default public String toInternalId(String value) {
        if (StringUtils.hasText((String)value)) {
            if (DomainIdSerialization.hasVariableSyntax(value)) {
                return value;
            }
            return IdType.DOMAIN.convertToInternalId(value);
        }
        return value;
    }
}

