package com.xebialabs.xlrelease.serialization.json.jackson;

import java.io.IOException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

import com.xebialabs.deployit.util.PasswordEncrypter;

import static com.google.common.base.Strings.isNullOrEmpty;

public class PasswordDeserializer extends JsonDeserializer<String> {

    @Override
    public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String value = jsonParser.readValueAs(String.class);
        if (isValueEncrypted(value)) {
            throw new IllegalArgumentException("Could not accept encrypted password");
        }
        return value;
    }

    private boolean isValueEncrypted(String value) {
        return !isNullOrEmpty(value) && PasswordEncrypter.getInstance().isEncodedAndDecryptable(value);
    }
}
