package com.xebialabs.xlrelease.runner.repository

import com.xebialabs.xlrelease.runner.domain.RunnerId

import java.util.Date

trait RunnerTokenRepository {

  def exists(runnerId: RunnerId): Boolean

  def findByToken(tokenHash: String): Option[RunnerId]

  def create(runnerId: RunnerId, tokenHash: String, expiryDate: Date): Unit

  def update(runnerId: RunnerId, tokenHash: String, expiryDate: Date): Unit

  def delete(runnerId: RunnerId): Unit

  def findExpiryDate(tokenHash: String): Option[Date]
}
