/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ScriptTimeoutContext {
    private final boolean timeoutEnabled;
    private final Duration timeout;
    private String settingsKey;
    private final ScheduledExecutorService timeoutExecutor;
    private final AtomicBoolean completionStatus = new AtomicBoolean(false);
    private volatile boolean timeoutHappened;

    public ScriptTimeoutContext(boolean timeoutEnabled, ScheduledExecutorService timeoutExecutor, Duration timeout, String settingsKey) {
        this.timeoutEnabled = timeoutEnabled;
        this.timeoutExecutor = timeoutExecutor;
        this.timeout = timeout;
        this.settingsKey = settingsKey;
    }

    void registerTimeout() {
        Thread executionThread = Thread.currentThread();
        if (this.timeoutEnabled && this.timeoutExecutor != null) {
            this.timeoutExecutor.schedule(() -> this.interruptScript(executionThread), this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void interruptScript(Thread executionThread) {
        if (this.completionStatus.compareAndSet(false, true)) {
            this.timeoutHappened = true;
            executionThread.interrupt();
        }
    }

    synchronized void cleanupTimeout() {
        if (this.timeoutEnabled && !this.completionStatus.compareAndSet(false, true)) {
            Thread.interrupted();
        }
    }

    boolean isTimedOut() {
        return this.timeoutHappened;
    }

    String getSettingsKey() {
        return this.settingsKey;
    }

    public static ScriptTimeoutContext noTimeoutContext() {
        return new ScriptTimeoutContext(false, null, Duration.ZERO, "");
    }
}

