package com.xebialabs.xlrelease.script

import com.xebialabs.platform.script.jython.ScriptSource

case class XlrScript(name: String, scriptSource: ScriptSource, checkPermissions: Boolean, wrap: Boolean)

object XlrScript {
  def byResource(resource: String, wrap: Boolean, checkPermissions: Boolean): XlrScript = {
    byResource(resource, resource, wrap, checkPermissions)
  }

  def byResource(name: String, resource: String, wrap: Boolean, checkPermissions: Boolean): XlrScript = {
    XlrScript(name, ScriptSource.byResource(resource), checkPermissions, wrap)
  }

  def byContent(name: String, content: String,  wrap: Boolean, checkPermissions: Boolean): XlrScript = {
    XlrScript(name, ScriptSource.byContent(content), checkPermissions, wrap)
  }

}