package com.xebialabs.xlrelease.script.jython

import com.xebialabs.xlrelease.script.security.SandboxSupport
import grizzled.slf4j.Logging

class JythonScriptClassLoader(val parent: ClassLoader) extends ClassLoader(parent) with SandboxSupport with Logging {
  @throws[ClassNotFoundException]
  override protected def loadClass(name: String, resolve: Boolean): Class[_] = {
    if (!hasClassAccess(name)) {
      val message = s"Loading the restricted class [$name] is not allowed. Please update the script.policy file if you wish to grant access."
      logger.warn(message)
      throw new ClassNotFoundException(message)
    }
    super.loadClass(name, resolve)
  }
}
