package com.xebialabs.xlrelease.script.jython;

import java.security.AccessControlContext;
import java.util.List;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

import com.xebialabs.xlrelease.script.Jsr223EngineFactory;
import com.xebialabs.xlrelease.script.Jsr223ScriptExecutor;
import com.xebialabs.xlrelease.script.ScriptPermissionsProvider;

import static com.xebialabs.xlrelease.script.XlrScriptContext.CONTEXT_BINDINGS_TO_UNWRAP;
import static com.xebialabs.xlrelease.script.XlrScriptContext.CONTEXT_BINDINGS_TO_WRAP;
import static scala.jdk.javaapi.CollectionConverters.asScala;

public class JythonScriptExecutor extends Jsr223ScriptExecutor {
    private JythonScriptValidator scriptValidator;

    public JythonScriptExecutor(Jsr223EngineFactory jythonEngineInstance,
                                ScriptPermissionsProvider scriptPermissionsProvider,
                                JythonScriptValidator scriptValidator,
                                Boolean sandboxEnabled,
                                String workDir) {
        // Quick fix alert, see the following JIRA comment for details:
        // https://digitalai.atlassian.net/browse/REL-3678?focusedCommentId=59693&page=com.atlassian.jira.plugin.system.issuetabpanels%3Acomment-tabpanel#comment-59693
        super(jythonEngineInstance, scriptPermissionsProvider, sandboxEnabled, workDir);
        this.scriptValidator = scriptValidator;
    }

    @Override
    protected Object evalScriptPrivileged(ScriptEngine engine, String script, ScriptContext scriptContext, AccessControlContext accessControlContext) throws Exception {
        if (isRestricted(accessControlContext != null)) {
            scriptValidator.validate(script, "UTF-8");
        }
        try {
            wrapBindings(engine, scriptContext);
            Object result = doPrivileged(engine, script, scriptContext, accessControlContext);
            unwrapBindings(engine, scriptContext);
            return result;
        } catch (ClassNotFoundException e) {
            throw new ScriptException(new SecurityException(e.getMessage()));
        }
    }

    private void wrapBindings(ScriptEngine engine, ScriptContext scriptContext) throws Exception {
        @SuppressWarnings("unchecked")
        List<String> bindingsToWrap = (List<String>) scriptContext.getAttribute(CONTEXT_BINDINGS_TO_WRAP);
        if (bindingsToWrap != null) {
            doPrivileged(engine, JythonScriptHelper.wrapBindings(asScala(bindingsToWrap).toIterable()).scriptContent(), scriptContext, null);
        }
    }

    private void unwrapBindings(ScriptEngine engine, ScriptContext scriptContext) throws Exception {
        @SuppressWarnings("unchecked")
        List<String> bindingsToUnwrap = (List<String>) scriptContext.getAttribute(CONTEXT_BINDINGS_TO_UNWRAP);
        if (bindingsToUnwrap != null) {
            doPrivileged(engine, JythonScriptHelper.unwrapBindings(asScala(bindingsToUnwrap).toIterable()).scriptContent(), scriptContext, null);
        }
    }
}
