package com.xebialabs.xlrelease.security

import com.xebialabs.xlplatform.repository.sql.Database
import com.xebialabs.xlrelease.security.sql.db.Ids.{GLOBAL_SCOPE_CI_ID, isGlobalId}
import com.xebialabs.xlrelease.security.sql.db.Tables.HasCiRef
import slick.jdbc.JdbcProfile

package object sql {

  lazy val profile: JdbcProfile = Database.databaseType.profile

  import profile.api._

  implicit class HasCiRefExtensions(val ciRef: HasCiRef) {
    def isOnConfigurationItem(ciId: Option[String]): Rep[Boolean] = if (isGlobalId(ciId)) isGlobal else ciRef.ciId === ciId.get.toInt

    def isGlobal: Rep[Boolean] = ciRef.ciId === GLOBAL_SCOPE_CI_ID
  }

  implicit class StringColumnExtensions[TP](val column: Rep[String]) {
    def in(seq: Iterable[String]): Rep[Boolean] = column.inSet(seq.filter(Option(_).isDefined))
  }

  implicit class StringOptionColumnExtensions[TP](val column: Rep[Option[String]]) {
    def in(seq: Iterable[String]): Rep[Option[Boolean]] = column.inSet(seq.filter(Option(_).isDefined))
  }


  implicit class MapExtensions[K, V](val value: Map[K, V]) {

    import scala.collection.JavaConverters._

    def asJavaMutable(): java.util.Map[K, V] = new java.util.HashMap[K, V](value.asJava)
  }

  implicit class SetExtensions[V](val value: Set[V]) {

    import scala.collection.JavaConverters._

    def asJavaMutable(): java.util.Set[V] = new java.util.HashSet[V](value.asJava)
  }

  implicit class ListExtensions[V](val value: Seq[V]) {

    import scala.collection.JavaConverters._

    def asJavaMutable(): java.util.List[V] = new java.util.ArrayList[V](value.asJava)
  }

}
