package com.xebialabs.xlrelease.security.sql

import java.util

import com.xebialabs.deployit.engine.api.dto.Paging
import com.xebialabs.deployit.security.{PermissionLister, Role}
import com.xebialabs.xlplatform.repository.sql.Database
import com.xebialabs.xlrelease.security.sql.db.Ids.fromDbId
import com.xebialabs.xlrelease.security.sql.db.Tables
import slick.jdbc.JdbcProfile

import scala.collection.JavaConverters._

class SqlPermissionLister(securityDatabase: Database) extends PermissionLister {

  import securityDatabase._

  val profile: JdbcProfile = config.databaseType.profile

  import profile.api._

  type Q = Query[Tables.RolePermissions, Tables.RolePermission, Seq]

  override def listPermissions(role: Role, paging: Paging): util.Map[String, util.List[String]] =
    listPermissions(Seq(role), includeCiPermissions = true, paging)

  override def listPermissions(roles: util.List[Role], paging: Paging): util.Map[String, util.List[String]] =
    listPermissions(roles.asScala, includeCiPermissions = true, paging)

  override def listGlobalPermissions(roles: util.List[Role], paging: Paging): util.Map[String, util.List[String]] =
    listPermissions(roles.asScala, includeCiPermissions = false, paging)

  private def listPermissions(roles: Seq[Role], includeCiPermissions: Boolean, paging: Paging): util.Map[String, util.List[String]] = {
    var query = Tables.roles
      .join(Tables.rolePermissions).on(_.id === _.roleId)
      .filter(_._1.id.in(roles.map(_.getId)))
      .map(_._2)

    if (!includeCiPermissions) {
      query = query.filter(_.isGlobal)
    }

    val groupedPermissions: Map[String, Seq[(String, String)]] = runAwait(query.result)
      .map(permission => fromDbId(permission.ciId) -> permission.permissionName)
      .groupBy(_._1)

    (Option(paging) match {
      case Some(p) if p.resultsPerPage != -1 => groupedPermissions.slice(
        (p.page - 1) * p.resultsPerPage,
        (p.page - 1) * p.resultsPerPage + p.resultsPerPage)
      case _ => groupedPermissions
    }).mapValues(_.toList.map(_._2).asJavaMutable())
      .asJavaMutable()
  }
}
