/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.package;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.utils.DateVariableUtils;
import java.io.Serializable;
import java.util.Date;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005mv!\u0002\u0010 \u0011\u0003ac!\u0002\u0018 \u0011\u0003y\u0003\"\u0002\u001c\u0002\t\u00039\u0004\"\u0002\u001d\u0002\t\u0003Id\u0001\u0002\u0018 \u0001)C\u0011b\u0015\u0003\u0003\u0002\u0003\u0006Y\u0001V3\t\u000bY\"A\u0011\u00014\t\u000b%$A\u0011\u00016\t\u000b-$A\u0011\u00017\t\u000f\u0005\u0005A\u0001\"\u0001\u0002\u0004!9\u0011\u0011\u0005\u0003\u0005\u0002\u0005\r\u0002bBA\u0018\t\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003o!A\u0011AA\u001d\u0011\u001d\t\u0019\u0006\u0002C\u0001\u0003+Bq!a\u0017\u0005\t\u0003\ti\u0006C\u0004\u0002b\u0011!\t!a\u0019\t\u000f\u0005%D\u0001\"\u0001\u0002l!9\u0011q\u000f\u0003\u0005\u0002\u0005e\u0004bBAA\t\u0011\u0005\u00111\u0011\u0005\u0007\u0003'#A\u0011\u00016\t\r\u0005UE\u0001\"\u0001k\u0011\u001d\t9\n\u0002C\u0005\u00033Cq!!)\u0005\t\u0013\t\u0019\u000bC\u0004\u0002,\u0012!I!a)\t\u000f\u00055F\u0001\"\u0003\u0002$\"9\u0011q\u0016\u0003\u0005\n\u0005\r\u0006bBAY\t\u0011%\u00111\u0015\u0005\b\u0003g#A\u0011BAR\u0011\u001d\t)\f\u0002C\u0005\u0003GCq!a.\u0005\t\u0003\nI,A\bUCN\\7oU9m\u0005VLG\u000eZ3s\u0015\t\u0001\u0013%A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'B\u0001\u0012$\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003I\u0015\n!B]3q_NLGo\u001c:z\u0015\t1s%A\u0005yYJ,G.Z1tK*\u0011\u0001&K\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AK\u0001\u0004G>l7\u0001\u0001\t\u0003[\u0005i\u0011a\b\u0002\u0010)\u0006\u001c8n]*rY\n+\u0018\u000e\u001c3feN\u0011\u0011\u0001\r\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005a\u0013!\u00048pe6\fG.\u001b>f)\u0006<7\u000f\u0006\u0002;\u0011B\u00191HQ#\u000f\u0005q\u0002\u0005CA\u001f3\u001b\u0005q$BA ,\u0003\u0019a$o\\8u}%\u0011\u0011IM\u0001\u0007!J,G-\u001a4\n\u0005\r#%aA*fi*\u0011\u0011I\r\t\u0003w\u0019K!a\u0012#\u0003\rM#(/\u001b8h\u0011\u0015I5\u00011\u0001;\u0003\u0011!\u0018mZ:\u0014\u0005\u0011Y\u0005c\u0001'Q%6\tQJ\u0003\u0002#\u001d*\u0011q*J\u0001\u0003I\nL!!U'\u0003\u0015M\u000bHNQ;jY\u0012,'\u000f\u0005\u0002.\t\u00059A-[1mK\u000e$\bCA+c\u001d\t1\u0006M\u0004\u0002X?:\u0011\u0001L\u0018\b\u00033vs!A\u0017/\u000f\u0005uZ\u0016\"\u0001\u0016\n\u0005!J\u0013B\u0001\u0014(\u0013\tyU%\u0003\u0002#\u001d&\u0011\u0011-T\u0001\u000b'Fd')^5mI\u0016\u0014\u0018BA2e\u0005\u001d!\u0015.\u00197fGRT!!Y'\n\u0005M\u0003F#A4\u0015\u0005IC\u0007\"B*\u0007\u0001\b!\u0016\u0001D:fY\u0016\u001cG\u000fV1tW&#G#\u0001*\u00021]LG\u000f[(oK>3'+\u001a7fCN,7\u000b^1ukN,7\u000f\u0006\u0002S[\")a\u000e\u0003a\u0001_\u0006A1\u000f^1ukN,7\u000fE\u0002qkbt!!]:\u000f\u0005u\u0012\u0018\"A\u001a\n\u0005Q\u0014\u0014a\u00029bG.\fw-Z\u0005\u0003m^\u00141aU3r\u0015\t!(\u0007\u0005\u0002z}6\t!P\u0003\u0002|y\u000611\u000f^1ukNT!!`\u0013\u0002\r\u0011|W.Y5o\u0013\ty(PA\u0007SK2,\u0017m]3Ti\u0006$Xo]\u0001\u0010o&$\b\u000eV1tWRK\b/\u001a(piR\u0019!+!\u0002\t\u000f\u0005\u001d\u0011\u00021\u0001\u0002\n\u0005AA/Y:l)f\u0004X\r\u0005\u0003\u0002\f\u0005uQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u000fI,g\r\\3di*!\u00111CA\u000b\u0003\r\t\u0007/\u001b\u0006\u0005\u0003/\tI\"\u0001\u0004qYV<\u0017N\u001c\u0006\u0004\u000379\u0013\u0001\u00033fa2|\u00170\u001b;\n\t\u0005}\u0011Q\u0002\u0002\u0005)f\u0004X-A\u000bxSRDwJ\\3PMR\u000b7o[*uCR,8/Z:\u0015\u0007I\u000b)\u0003\u0003\u0004o\u0015\u0001\u0007\u0011q\u0005\t\u0005aV\fI\u0003E\u0002z\u0003WI1!!\f{\u0005)!\u0016m]6Ti\u0006$Xo]\u0001\u000bo&$\bNR5mi\u0016\u0014Hc\u0001*\u00024!1\u0011QG\u0006A\u0002\u0015\u000baAZ5mi\u0016\u0014\u0018!C<ji\"$\u0015\r^3t)\u0015\u0011\u00161HA(\u0011\u001d\ti\u0004\u0004a\u0001\u0003\u007f\tAA\u001a:p[B!\u0011\u0011IA&\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013\u0001B;uS2T!!!\u0013\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\n\u0019E\u0001\u0003ECR,\u0007bBA)\u0019\u0001\u0007\u0011qH\u0001\u0003i>\fac^5uQN\u001b\u0007.\u001a3vY\u0016$7\u000b^1si\u0012\u000bG/\u001a\u000b\u0004%\u0006]\u0003bBA-\u001b\u0001\u0007\u0011qH\u0001\u0005I\u0006$X-A\u0007xSRD\u0017I\\=PMR\u000bwm\u001d\u000b\u0004%\u0006}\u0003\"B%\u000f\u0001\u0004Q\u0014!D<ji\"4u\u000e\u001c3fe&#7\u000fF\u0002S\u0003KBa!a\u001a\u0010\u0001\u0004Q\u0014!\u00034pY\u0012,'/\u00133t\u0003A9\u0018\u000e\u001e5BgNLwM\\3e)>lU\rF\u0002S\u0003[Bq!a\u001c\u0011\u0001\u0004\t\t(\u0001\u0006qe&t7-\u001b9bYN\u0004B\u0001]A:\u000b&\u0019\u0011QO<\u0003\u0011%#XM]1cY\u0016\f\u0011d^5uQ\u0006\u001b8/[4oK\u0012$v.T3Pe6KH+Z1ngR)!+a\u001f\u0002~!9\u0011qN\tA\u0002\u0005E\u0004bBA@#\u0001\u0007\u0011\u0011O\u0001\be>dW-\u00133t\u0003U9\u0018\u000e\u001e5BgNLwM\\3e)>\fe.\u001f2pIf$rAUAC\u0003\u000f\u000bI\tC\u0004\u0002pI\u0001\r!!\u001d\t\u000f\u0005}$\u00031\u0001\u0002r!9\u00111\u0012\nA\u0002\u00055\u0015aB5t\u0003\u0012l\u0017N\u001c\t\u0004c\u0005=\u0015bAAIe\t9!i\\8mK\u0006t\u0017!D<ji\"\fe.\u001f$bG\u0016$8/A\u0007pe\u0012,'OQ=UCN\\\u0017\nZ\u0001\bE&tG-\u001b8h)\r)\u00151\u0014\u0005\b\u0003;+\u0002\u0019AAP\u0003\u00191\u0018\r\\;fgB!\u0001/a\u001d1\u0003%Qw.\u001b8UK\u0006l7\u000f\u0006\u0002\u0002&B\u0019\u0011'a*\n\u0007\u0005%&G\u0001\u0003V]&$\u0018\u0001\u00056pS:$V-Y7t)>$\u0016m]6t\u00035Qw.\u001b8UK\u0006l'k\u001c7fg\u0006\u0011\"n\\5o)\u0016\fW\u000e\u0015:j]\u000eL\u0007/\u00197t\u0003MQw.\u001b8UK\u0006l\u0007+\u001a:nSN\u001c\u0018n\u001c8t\u0003-Qw.\u001b8G_2$WM]:\u0002\u0015)|\u0017N\u001c$bG\u0016$8/A\u0006oK^Len\u001d;b]\u000e,W#\u0001*")
public class TasksSqlBuilder
extends SqlBuilder<TasksSqlBuilder> {
    public static Set<String> normalizeTags(Set<String> set) {
        return TasksSqlBuilder$.MODULE$.normalizeTags(set);
    }

    public TasksSqlBuilder selectTaskId() {
        return (TasksSqlBuilder)super.select(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(127).append("SELECT\n         |  DISTINCT tasks.").append(Schema.TASKS$.MODULE$.TASK_ID()).append("\n         |FROM\n         |  ").append(Schema.TASKS$.MODULE$.TABLE()).append(" tasks\n         |  JOIN ").append(Schema.RELEASES$.MODULE$.TABLE()).append(" releases ON tasks.").append(Schema.TASKS$.MODULE$.RELEASE_UID()).append(" = releases.").append(Schema.RELEASES$.MODULE$.CI_UID()).append("\n         ").toString())).stripMargin());
    }

    public TasksSqlBuilder withOneOfReleaseStatuses(Seq<ReleaseStatus> statuses) {
        Object object = statuses.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(15).append("releases.").append(Schema.RELEASES$.MODULE$.STATUS()).append(" IN (").append(this.binding((Iterable<Object>)statuses)).append(")").toString(), (Iterable)statuses.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.value(), Seq$.MODULE$.canBuildFrom()))) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withTaskTypeNot(Type taskType) {
        this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(11).append("tasks.").append(Schema.TASKS$.MODULE$.TASK_TYPE()).append(" != ?").toString(), (Iterable)new .colon.colon((Object)taskType.toString(), (List)Nil$.MODULE$)));
        return this;
    }

    public TasksSqlBuilder withOneOfTaskStatuses(Seq<TaskStatus> statuses) {
        Object object = statuses.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(12).append("tasks.").append(Schema.TASKS$.MODULE$.STATUS()).append(" IN (").append(this.binding((Iterable<Object>)statuses)).append(")").toString(), (Iterable)statuses.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.value(), Seq$.MODULE$.canBuildFrom()))) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withFilter(String filter) {
        Object object = filter != null ? this.likeOr((Seq)new .colon.colon((Object)new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.TITLE()).toString(), (List)new .colon.colon((Object)new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.OWNER()).toString(), (List)new .colon.colon((Object)new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.TEAM()).toString(), (List)new .colon.colon((Object)new StringBuilder(9).append("releases.").append(Schema.RELEASES$.MODULE$.RELEASE_TITLE()).toString(), (List)Nil$.MODULE$)))), filter) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withDates(Date from, Date to) {
        Object object;
        if (from != null && to != null) {
            object = this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(43).append("(? <= tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" OR ? <= tasks.").append(Schema.TASKS$.MODULE$.END_DATE()).append(") AND tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" < ?").toString(), (Iterable)new .colon.colon((Object)from, (List)new .colon.colon((Object)from, (List)new .colon.colon((Object)to, (List)Nil$.MODULE$)))));
        } else {
            Object object2 = from != null ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(28).append("(? <= tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" OR ? <= tasks.").append(Schema.TASKS$.MODULE$.END_DATE()).append(")").toString(), (Iterable)new .colon.colon((Object)from, (List)new .colon.colon((Object)from, (List)Nil$.MODULE$)))) : BoxedUnit.UNIT;
            object = to != null ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(10).append("tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" < ?").toString(), (Iterable)new .colon.colon((Object)to, (List)Nil$.MODULE$))) : BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withScheduledStartDate(Date date) {
        this.conditions().$plus$eq((Object)new package.Sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(32).append("\n         |tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" = ?\n         |").toString())).stripMargin(), (Iterable)new .colon.colon((Object)new Date(Predef$.MODULE$.Long2long(DateVariableUtils.truncateMilliseconds((Long)Predef$.MODULE$.long2Long(date.getTime())))), (List)Nil$.MODULE$)));
        return this;
    }

    public TasksSqlBuilder withAnyOfTags(Set<String> tags) {
        BoxedUnit boxedUnit;
        Set<String> normalizedTags = TasksSqlBuilder$.MODULE$.normalizeTags(tags);
        if (normalizedTags.nonEmpty()) {
            String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(159).append("\n           |tasks.").append(Schema.TASKS$.MODULE$.CI_UID()).append(" IN (\n           |  SELECT DISTINCT task_tags.").append(Schema.TASK_TAGS$.MODULE$.CI_UID()).append("\n           |  FROM ").append(Schema.TASK_TAGS$.MODULE$.TABLE()).append(" task_tags\n           |  WHERE task_tags.").append(Schema.TASK_TAGS$.MODULE$.VALUE()).append(" IN (").append(this.binding((Iterable<Object>)normalizedTags)).append(")\n           |)\n           |").toString())).stripMargin();
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(sql, normalizedTags));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withFolderIds(Set<String> folderIds) {
        BoxedUnit boxedUnit;
        Set normalizedFolderIds = (Set)folderIds.map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getName((String)x$1), Set$.MODULE$.canBuildFrom());
        if (normalizedFolderIds.nonEmpty()) {
            this.joinFolders();
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(14).append("folders.").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append(" IN (").append(this.binding((Iterable<Object>)normalizedFolderIds)).append(")").toString(), (Iterable)normalizedFolderIds));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAssignedToMe(Iterable<String> principals) {
        BoxedUnit boxedUnit;
        if (principals.nonEmpty()) {
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(19).append("LOWER(tasks.").append(Schema.TASKS$.MODULE$.OWNER()).append(") IN (").append(this.binding(principals)).append(")").toString(), (Iterable)principals.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toLowerCase(), Iterable$.MODULE$.canBuildFrom())));
        } else {
            this.nothingToBeFound_$eq(true);
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAssignedToMeOrMyTeams(Iterable<String> principals, Iterable<String> roleIds) {
        this.joinTeamsToTasks();
        Seq orConditions = (Seq)Nil$.MODULE$;
        if (principals.nonEmpty()) {
            orConditions = (Seq)orConditions.$plus$plus((GenTraversableOnce)new .colon.colon((Object)new package.Sql(new StringBuilder(19).append("LOWER(tasks.").append(Schema.TASKS$.MODULE$.OWNER()).append(") IN (").append(this.binding(principals)).append(")").toString(), (Iterable)principals.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toLowerCase(), Iterable$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
            orConditions = (Seq)orConditions.$plus$plus((GenTraversableOnce)new .colon.colon((Object)new package.Sql(new StringBuilder(105).append("teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" IN (SELECT ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId()).append(" FROM ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE()).append(" assignedToMeOrTeamsPrincipals WHERE LOWER(assignedToMeOrTeamsPrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.principalName()).append(") IN (").append(this.binding(principals)).append("))").toString(), (Iterable)principals.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toLowerCase(), Iterable$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
        }
        if (roleIds.nonEmpty()) {
            orConditions = (Seq)orConditions.$plus$plus((GenTraversableOnce)new .colon.colon((Object)new package.Sql(new StringBuilder(95).append("teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" IN (SELECT ").append(SecuritySchema.ROLE_ROLES$.MODULE$.roleId()).append(" FROM ").append(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE()).append(" assignedToMeOrTeamsRoles WHERE LOWER(assignedToMeOrTeamsRoles.").append(SecuritySchema.ROLE_ROLES$.MODULE$.memberRoleId()).append(") IN (").append(this.binding(roleIds)).append("))").toString(), (Iterable)roleIds.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toLowerCase(), Iterable$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
        }
        ArrayBuffer arrayBuffer = orConditions.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(2).append("(").append(((TraversableOnce)orConditions.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(2).append("(").append(c.sql()).append(")").toString(), Seq$.MODULE$.canBuildFrom())).mkString(" OR ")).append(")").toString(), (Iterable)orConditions.flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.parameters(), Seq$.MODULE$.canBuildFrom()))) : this.conditions().$plus$eq((Object)new package.Sql("(1 = 0)", (Iterable)Nil$.MODULE$));
        return this;
    }

    public TasksSqlBuilder withAssignedToAnybody(Iterable<String> principals, Iterable<String> roleIds, boolean isAdmin) {
        BoxedUnit boxedUnit;
        if (!isAdmin) {
            Seq orConditions = (Seq)Nil$.MODULE$;
            if (roleIds.nonEmpty()) {
                orConditions = (Seq)orConditions.$plus$plus((GenTraversableOnce)new .colon.colon((Object)new package.Sql(new StringBuilder(49).append("(LOWER(assignedToTeamRoles.MEMBER_ROLE_ID) IN (").append(this.binding(roleIds)).append("))").toString(), (Iterable)roleIds.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toLowerCase(), Iterable$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
            }
            if (principals.nonEmpty()) {
                orConditions = (Seq)orConditions.$plus$plus((GenTraversableOnce)new .colon.colon((Object)new package.Sql(new StringBuilder(54).append("(LOWER(assignedToTeamPrincipals.PRINCIPAL_NAME) IN (").append(this.binding(principals)).append("))").toString(), (Iterable)principals.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toLowerCase(), Iterable$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
            }
            boxedUnit = orConditions.isEmpty() ? this.conditions().$plus$eq((Object)new package.Sql("(1 = 0)", (Iterable)Nil$.MODULE$)) : this.conditions().$plus$eq((Object)new package.Sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(425).append("releases.").append(Schema.RELEASES$.MODULE$.SECURITY_UID()).append(" IN (\n             |  SELECT assignedToTeams.").append(SecuritySchema.ROLES$.MODULE$.ciId()).append(" FROM ").append(SecuritySchema.ROLES$.MODULE$.TABLE()).append(" assignedToTeams\n             |  JOIN ").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE()).append(" assignedToTeamPermissions ON assignedToTeams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = assignedToTeamPermissions.").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.roleId()).append("\n             |  LEFT JOIN ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE()).append(" assignedToTeamPrincipals ON assignedToTeams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = assignedToTeamPrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId()).append("\n             |  LEFT JOIN ").append(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE()).append(" assignedToTeamRoles ON assignedToTeams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = assignedToTeamRoles.").append(SecuritySchema.ROLE_ROLES$.MODULE$.roleId()).append("\n             |  WHERE assignedToTeamPermissions.").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.permissionName()).append(" = '").append(XLReleasePermissions.VIEW_RELEASE.getPermissionName()).append("' AND (").append(((TraversableOnce)orConditions.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.sql(), Seq$.MODULE$.canBuildFrom())).mkString(" OR ")).append("))").toString())).stripMargin(), (Iterable)orConditions.flatMap((Function1 & Serializable & scala.Serializable)x$12 -> x$12.parameters(), Seq$.MODULE$.canBuildFrom())));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAnyFacets() {
        this.joinFacets();
        return this;
    }

    public TasksSqlBuilder orderByTaskId() {
        this.orderBy(new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.TASK_ID()).toString());
        return this;
    }

    private String binding(Iterable<Object> values) {
        return ((TraversableOnce)values.toSeq().map((Function1 & Serializable & scala.Serializable)x$13 -> "?", Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    private void joinTeams() {
        this.addJoin(new StringBuilder(33).append("JOIN ").append(SecuritySchema.ROLES$.MODULE$.TABLE()).append(" teams ON releases.").append(Schema.RELEASES$.MODULE$.SECURITY_UID()).append(" = teams.").append(SecuritySchema.ROLES$.MODULE$.ciId()).toString());
    }

    private void joinTeamsToTasks() {
        this.addJoin(new StringBuilder(58).append("LEFT JOIN ").append(SecuritySchema.ROLES$.MODULE$.TABLE()).append(" teams ON releases.").append(Schema.RELEASES$.MODULE$.SECURITY_UID()).append(" = teams.").append(SecuritySchema.ROLES$.MODULE$.ciId()).append(" AND tasks.").append(Schema.TASKS$.MODULE$.TEAM()).append(" = teams.").append(SecuritySchema.ROLES$.MODULE$.name()).toString());
    }

    private void joinTeamRoles() {
        this.addJoin(new StringBuilder(43).append("LEFT JOIN ").append(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE()).append(" teamRoles ON teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = teamRoles.").append(SecuritySchema.ROLE_ROLES$.MODULE$.roleId()).toString());
    }

    private void joinTeamPrincipals() {
        this.addJoin(new StringBuilder(53).append("LEFT JOIN ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE()).append(" teamPrincipals ON teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = teamPrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId()).toString());
    }

    private void joinTeamPermissions() {
        this.addJoin(new StringBuilder(50).append("JOIN ").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE()).append(" teamPermissions ON teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = teamPermissions.").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.roleId()).toString());
    }

    private void joinFolders() {
        this.addJoin(new StringBuilder(37).append("JOIN ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" folders ON releases.").append(Schema.RELEASES$.MODULE$.FOLDER_CI_UID()).append(" = folders.").append(Schema.FOLDERS$.MODULE$.CI_UID()).toString());
    }

    private void joinFacets() {
        this.addJoin(new StringBuilder(32).append("JOIN ").append(Schema.FACETS$.MODULE$.TABLE()).append(" facets ON tasks.").append(Schema.TASKS$.MODULE$.CI_UID()).append(" = facets.").append(Schema.FACETS$.MODULE$.APPLIED_TO_TASK_UID()).toString());
    }

    public TasksSqlBuilder newInstance() {
        return new TasksSqlBuilder(super.dialect());
    }

    public TasksSqlBuilder(SqlBuilder.Dialect dialect) {
        super(dialect);
    }
}

