/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlReleaseRepositoryHelper;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.utils.Diff$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\rUg\u0001B\u001a5\u0001}B\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\tY\u0002\u0011)\u0019!C\t[\"A\u0011\u000f\u0001B\u0001B\u0003%a\u000e\u0003\u0005s\u0001\t\u0015\r\u0011\"\u0005t\u0011!9\bA!A!\u0002\u0013!\b\u0002\u0003=\u0001\u0005\u000b\u0007I\u0011C=\t\u0011u\u0004!\u0011!Q\u0001\niD\u0001B \u0001\u0003\u0006\u0004%\tb \u0005\u000b\u0003\u000f\u0001!\u0011!Q\u0001\n\u0005\u0005\u0001BCA\u0005\u0001\t\u0015\r\u0011\"\u0005\u0002\f!Q\u00111\u0003\u0001\u0003\u0002\u0003\u0006I!!\u0004\t\u0015\u0005U\u0001A!b\u0001\n\u0003\t9\u0002\u0003\u0006\u0002&\u0001\u0011\t\u0011)A\u0005\u00033A!\"a\n\u0001\u0005\u000b\u0007I\u0011AA\u0015\u0011)\t\t\u0004\u0001B\u0001B\u0003%\u00111\u0006\u0005\u000b\u0003g\u0001!\u0011!Q\u0001\n\u0005U\u0002BCA\u001e\u0001\t\u0015\r\u0011b\u0001\u0002>!Q\u0011Q\u000e\u0001\u0003\u0002\u0003\u0006I!a\u0010\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r!9\u00111\u0012\u0001\u0005B\u00055\u0005bBAg\u0001\u0011\u0005\u0013q\u001a\u0005\b\u0003O\u0004A\u0011IAu\u0011\u001d\t9\u000f\u0001C!\u0003_DqAa\u0003\u0001\t\u0003\u0012i\u0001C\u0004\u0003H\u0001!\tE!\u0013\t\u000f\tE\u0003\u0001\"\u0001\u0003T!9!q\u000f\u0001\u0005B\te\u0004b\u0002BF\u0001\u0011\u0005!Q\u0012\u0005\b\u00057\u0003A\u0011\tBO\u0011\u001d\u0011\t\f\u0001C!\u0005gCqA!/\u0001\t\u0013\u0011Y\fC\u0004\u0003D\u0002!\tE!2\t\u000f\t5\u0007\u0001\"\u0011\u0003P\"9!1\u001c\u0001\u0005B\tu\u0007b\u0002B\u0000\u0001\u0011\u00053\u0011\u0001\u0005\b\u0007\u000f\u0001A\u0011IB\u0005\u0011\u001d\u0019\u0019\u0002\u0001C!\u0007+Aqaa\b\u0001\t\u0003\u001a\t\u0003C\u0004\u00040\u0001!\te!\r\t\u000f\re\u0002\u0001\"\u0011\u0004<!911\t\u0001\u0005B\r\u0015\u0003bBB\"\u0001\u0011\u000531\n\u0005\b\u0007/\u0002A\u0011IB-\u0011\u001d\u0019\t\u0007\u0001C!\u0007GBqaa\u001d\u0001\t\u0013\u0019)\bC\u0004\u0004\n\u0002!Iaa#\t\u000f\rE\u0005\u0001\"\u0011\u0004\u0014\"91\u0011\u0016\u0001\u0005B\r-\u0006bBBY\u0001\u0011\u000531\u0017\u0005\b\u0007w\u0003A\u0011IB_\u0005Q\u0019\u0016\u000f\u001c*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss*\u0011QGN\u0001\u0004gFd'BA\u001c9\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003si\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005mb\u0014!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0014aA2p[\u000e\u00011\u0003\u0003\u0001A\r*#Fl\u00182\u0011\u0005\u0005#U\"\u0001\"\u000b\u0003\r\u000bQa]2bY\u0006L!!\u0012\"\u0003\r\u0005s\u0017PU3g!\t9\u0005*D\u00017\u0013\tIeGA\tSK2,\u0017m]3SKB|7/\u001b;pef\u00042a\u0013'O\u001b\u0005!\u0014BA'5\u0005UIe\u000e^3sG\u0016\u0004H/\u001a3SKB|7/\u001b;pef\u0004\"a\u0014*\u000e\u0003AS!!\u0015\u001d\u0002\r\u0011|W.Y5o\u0013\t\u0019\u0006KA\u0004SK2,\u0017m]3\u0011\u0005USV\"\u0001,\u000b\u0005]C\u0016!B:mMRR'\"A-\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\u0017,\u0003\u000f1{wmZ5oOB\u00111*X\u0005\u0003=R\u0012a\u0003R3tKJL\u0017\r\\5{CRLwN\\*vaB|'\u000f\u001e\t\u0003\u0017\u0002L!!\u0019\u001b\u0003=\r{gNZ5hkJ\fG/[8o%\u00164WM]3oG\u0016\u001c8+\u001e9q_J$\bCA&d\u0013\t!GG\u0001\u000eTc2\u0014V\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f%fYB,'/\u0001\nsK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007CA4k\u001b\u0005A'BA55\u0003-\u0001XM]:jgR,gnY3\n\u0005-D'A\u0005*fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016\fq\u0002^1tWB+'o]5ti\u0016t7-Z\u000b\u0002]B\u0011qm\\\u0005\u0003a\"\u0014q\u0002V1tWB+'o]5ti\u0016t7-Z\u0001\u0011i\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dK\u0002\nQ\u0003Z3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW-F\u0001u!\t9W/\u0003\u0002wQ\n)B)\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u00063fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-\u001a\u0011\u0002%\r|W.\\3oiB+'o]5ti\u0016t7-Z\u000b\u0002uB\u0011qm_\u0005\u0003y\"\u0014!cQ8n[\u0016tG\u000fU3sg&\u001cH/\u001a8dK\u0006\u00192m\\7nK:$\b+\u001a:tSN$XM\\2fA\u0005qA/Z1n%\u0016\u0004xn]5u_JLXCAA\u0001!\r9\u00151A\u0005\u0004\u0003\u000b1$A\u0004+fC6\u0014V\r]8tSR|'/_\u0001\u0010i\u0016\fWNU3q_NLGo\u001c:zA\u0005Y\"/\u001a7fCN,W\t\u001f;f]NLwN\\:SKB|7/\u001b;pef,\"!!\u0004\u0011\u0007\u001d\u000by!C\u0002\u0002\u0012Y\u00121DU3mK\u0006\u001cX-\u0012=uK:\u001c\u0018n\u001c8t%\u0016\u0004xn]5u_JL\u0018\u0001\b:fY\u0016\f7/Z#yi\u0016t7/[8ogJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0019G>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,WCAA\r!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010Q\u0006i1m\u001c8gS\u001e,(/\u0019;j_:LA!a\t\u0002\u001e\t\t3i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cW\rU3sg&\u001cH/\u001a8dK\u0006I2m\u001c8gS\u001e,(/\u0019;j_:\u0004VM]:jgR,gnY3!\u0003E\u0011X\r]8tSR|'/_!eCB$XM]\u000b\u0003\u0003W\u00012aSA\u0017\u0013\r\ty\u0003\u000e\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0002%I,\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000fI\u0001\u001aM\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\u0012K7\u000f]1uG\",'\u000fE\u0002H\u0003oI1!!\u000f7\u0005e1\u0015mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u0002\u0015M\fH\u000eR5bY\u0016\u001cG/\u0006\u0002\u0002@A!\u0011\u0011IA4\u001d\u0011\t\u0019%!\u0019\u000f\t\u0005\u0015\u0013Q\f\b\u0005\u0003\u000f\nIF\u0004\u0003\u0002J\u0005]c\u0002BA&\u0003+rA!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#r\u0014A\u0002\u001fs_>$h(C\u0001>\u0013\tYD(\u0003\u0002:u%\u0019\u00111\f\u001d\u0002\u0005\u0011\u0014\u0017bA\u001b\u0002`)\u0019\u00111\f\u001d\n\t\u0005\r\u0014QM\u0001\u000b'Fd')^5mI\u0016\u0014(bA\u001b\u0002`%!\u0011\u0011NA6\u0005\u001d!\u0015.\u00197fGRTA!a\u0019\u0002f\u0005Y1/\u001d7ES\u0006dWm\u0019;!\u0003\u0019a\u0014N\\5u}Q!\u00121OA=\u0003w\ni(a \u0002\u0002\u0006\r\u0015QQAD\u0003\u0013#B!!\u001e\u0002xA\u00111\n\u0001\u0005\b\u0003w\u0019\u00029AA \u0011\u0015)7\u00031\u0001g\u0011\u0015a7\u00031\u0001o\u0011\u0015\u00118\u00031\u0001u\u0011\u0015A8\u00031\u0001{\u0011\u0019q8\u00031\u0001\u0002\u0002!9\u0011\u0011B\nA\u0002\u00055\u0001bBA\u000b'\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003O\u0019\u0002\u0019AA\u0016\u0011\u001d\t\u0019d\u0005a\u0001\u0003k\ta!\u001a=jgR\u001cH\u0003BAH\u0003+\u00032!QAI\u0013\r\t\u0019J\u0011\u0002\b\u0005>|G.Z1o\u0011\u001d\t9\n\u0006a\u0001\u00033\u000b!!\u001b3\u0011\t\u0005m\u00151\u0015\b\u0005\u0003;\u000by\nE\u0002\u0002N\tK1!!)C\u0003\u0019\u0001&/\u001a3fM&!\u0011QUAT\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0015\")\u0007Q\tY\u000b\u0005\u0003\u0002.\u0006MVBAAX\u0015\u0011\t\t,!\u001a\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003k\u000byK\u0001\u0006JgJ+\u0017\rZ(oYfD3\u0001FA]!\u0011\tY,!3\u000e\u0005\u0005u&\u0002BA`\u0003\u0003\f!\"\u00198o_R\fG/[8o\u0015\u0011\t\u0019-!2\u0002\u000f5,GO]5dg*\u0019\u0011q\u0019\u001f\u0002\u0011\r|G-\u00195bY\u0016LA!a3\u0002>\n)A+[7fI\u000611M]3bi\u0016$RATAi\u0003+Da!a5\u0016\u0001\u0004q\u0015a\u0002:fY\u0016\f7/\u001a\u0005\b\u0003/,\u0002\u0019AAm\u0003U\u0011X\r\\3bg\u0016\u001c%/Z1uS>t7k\\;sG\u0016\u0004B!a7\u0002b6\u0011\u0011Q\u001c\u0006\u0004\u0003?\u0004\u0016AB3wK:$8/\u0003\u0003\u0002d\u0006u'!\u0006*fY\u0016\f7/Z\"sK\u0006$\u0018n\u001c8T_V\u00148-\u001a\u0015\u0004+\u0005e\u0016\u0001\u00034j]\u0012\u0014\u00150\u00133\u0015\u00079\u000bY\u000fC\u0004\u0002\u0018Z\u0001\r!!')\u0007Y\tI\fF\u0003O\u0003c\f\u0019\u0010C\u0004\u0002\u0018^\u0001\r!!'\t\u000f\u0005Ux\u00031\u0001\u0002x\u0006q!/Z:pYZ,w\n\u001d;j_:\u001c\b\u0003BA}\u0005\u000bi!!a?\u000b\u0007]\niP\u0003\u0003\u0002\u0000\n\u0005\u0011\u0001\u00026t_:T1Aa\u00019\u00035\u0019XM]5bY&T\u0018\r^5p]&!!qAA~\u00059\u0011Vm]8mm\u0016|\u0005\u000f^5p]ND3aFA]\u0003=1\u0017N\u001c3JIN\u0014\u0015p\u0015;biV\u001cH\u0003\u0002B\b\u0005C\u0001bA!\u0005\u0003\u001c\u0005ee\u0002\u0002B\n\u0005/qA!!\u0014\u0003\u0016%\t1)C\u0002\u0003\u001a\t\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u001e\t}!aA*fc*\u0019!\u0011\u0004\"\t\u000f\t\r\u0002\u00041\u0001\u0003&\u0005A1\u000f^1ukN,7\u000fE\u0003B\u0005O\u0011Y#C\u0002\u0003*\t\u0013!\u0002\u0010:fa\u0016\fG/\u001a3?!\u0011\u0011iCa\r\u000e\u0005\t=\"b\u0001B\u0019!\u000611\u000f^1ukNLAA!\u000e\u00030\ti!+\u001a7fCN,7\u000b^1ukND3\u0001GAVQ\rA\u0012\u0011\u0018\u0015\u00041\tu\u0002\u0003\u0002B \u0005\u0007j!A!\u0011\u000b\u0007\u0005}&)\u0003\u0003\u0003F\t\u0005#a\u0002<be\u0006\u0014xm]\u0001\u0014M&tGMQ=DC2,g\u000eZ1s)>\\WM\u001c\u000b\u0004\u001d\n-\u0003b\u0002B'3\u0001\u0007\u0011\u0011T\u0001\u000eG\u0006dWM\u001c3beR{7.\u001a8)\u0007e\tI,\u0001\rgS:$\u0017I]2iSZ\f'\r\\3SK2,\u0017m]3JIN$bAa\u0004\u0003V\t%\u0004b\u0002B,5\u0001\u0007!\u0011L\u0001\u0005I\u0006$X\r\u0005\u0003\u0003\\\t\u0015TB\u0001B/\u0015\u0011\u0011yF!\u0019\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005G\nAA[1wC&!!q\rB/\u0005\u0011!\u0015\r^3\t\u000f\t-$\u00041\u0001\u0003n\u0005A\u0001/Y4f'&TX\rE\u0002B\u0005_J1A!\u001dC\u0005\rIe\u000e\u001e\u0015\u00045\u0005-\u0006f\u0001\u000e\u0002:\u0006q1/\u001a;Qe\u0016\f%o\u00195jm\u0016$GC\u0002B>\u0005\u0003\u0013)\tE\u0002B\u0005{J1Aa C\u0005\u0011)f.\u001b;\t\u000f\t\r5\u00041\u0001\u0002\u001a\u0006I!/\u001a7fCN,\u0017\n\u001a\u0005\b\u0005\u000f[\u0002\u0019AAH\u0003-\u0001(/Z!sG\"Lg/\u001a3)\u0007m\tI,A\rgS:$\u0007K]3Be\u000eD\u0017N^1cY\u0016\u0014V\r\\3bg\u0016\u001cHC\u0002BH\u0005#\u0013)\nE\u0003\u0003\u0012\tma\nC\u0004\u0003\u0014r\u0001\rA!\u001c\u0002\tA\fw-\u001a\u0005\b\u0005Wb\u0002\u0019\u0001B7Q\ra\u00121\u0016\u0015\u00049\u0005e\u0016AB:fCJ\u001c\u0007\u000e\u0006\u0003\u0003 \n\u0015\u0006#\u0002B.\u0005Cs\u0015\u0002\u0002BR\u0005;\u0012A\u0001T5ti\"9!qU\u000fA\u0002\t%\u0016\u0001D:fCJ\u001c\u0007\u000eU1sC6\u001c\bcA$\u0003,&\u0019!Q\u0016\u001c\u0003+I+G.Z1tKN+\u0017M]2i\u0005f\u0004\u0016M]1ng\"\u001aQ$!/\u0002\r\u0011,G.\u001a;f)\u0011\u0011YH!.\t\u000f\u0005]e\u00041\u0001\u0002\u001a\"\u001aa$!/\u0002/\u0011,G.\u001a;f%\u0016dW-Y:f%\u00164WM]3oG\u0016\u001cHC\u0002B>\u0005{\u0013y\fC\u0004\u0002\u0018~\u0001\r!!'\t\u000f\t\u0005w\u00041\u0001\u0003n\u0005Q!/\u001a7fCN,W+\u001b3\u0002\u001b\u0011,G.\u001a;f/&$\b.V5e)\u0019\u0011YHa2\u0003J\"9\u0011q\u0013\u0011A\u0002\u0005e\u0005b\u0002BaA\u0001\u0007!Q\u000e\u0015\u0004A\u0005e\u0016\u0001B7pm\u0016$bAa\u001f\u0003R\nU\u0007b\u0002BjC\u0001\u0007\u0011\u0011T\u0001\u000b_JLw-\u001b8bY&#\u0007b\u0002BlC\u0001\u0007\u0011\u0011T\u0001\u0006]\u0016<\u0018\n\u001a\u0015\u0004C\u0005e\u0016AB4fiVKG\r\u0006\u0003\u0003`\nu\b#B!\u0003b\n\u0015\u0018b\u0001Br\u0005\n1q\n\u001d;j_:\u0004BAa:\u0003x:!!\u0011\u001eB{\u001d\u0011\u0011YOa=\u000f\t\t5(\u0011\u001f\b\u0005\u0003\u000f\u0012y/\u0003\u00028q%\u0011QGN\u0005\u0003SRJ1A!\u0007i\u0013\u0011\u0011IPa?\u0003\u000b\rKW+\u001b3\u000b\u0007\te\u0001\u000eC\u0004\u0002\u0018\n\u0002\r!!'\u0002\u0013\u001d,Go\u0015;biV\u001cH\u0003\u0002B\u0016\u0007\u0007Aq!a&$\u0001\u0004\tI\nK\u0002$\u0003s\u000b1bZ3u'R\fG/^:fgR!11BB\u0007!\u0019\u0011\tBa\u0007\u0003,!91q\u0002\u0013A\u0002\t=\u0011aA5eg\"\u001aA%!/\u0002\u001b\u001d,GOU5tWN\u001bwN]3t)\u0011\u00199b!\u0007\u0011\r\tE!1\u0004B7\u0011\u001d\u0019y!\na\u0001\u0005\u001fA3!JAVQ\r)\u0013\u0011X\u0001\u000eg\u0016$(+[:l'\u000e|'/Z:\u0015\u0011\tm41EB\u0013\u0007SAqAa!'\u0001\u0004\tI\nC\u0004\u0004(\u0019\u0002\rA!\u001c\u0002\u000bM\u001cwN]3\t\u000f\r-b\u00051\u0001\u0003n\u0005QAo\u001c;bYN\u001bwN]3)\u0007\u0019\nI,\u0001\u0006jgR+W\u000e\u001d7bi\u0016$B!a$\u00044!9!1Q\u0014A\u0002\u0005e\u0005fA\u0014\u0002,\"\u001aq%!/\u0002\u0011\u001d,G\u000fV5uY\u0016$B!!'\u0004>!9\u0011q\u0013\u0015A\u0002\u0005e\u0005f\u0001\u0015\u0002,\"\u001a\u0001&!/\u0002\rU\u0004H-\u0019;f)\rq5q\t\u0005\u0007\u0003'L\u0003\u0019\u0001()\u0007%\nI\fF\u0003O\u0007\u001b\u001a\t\u0006\u0003\u0004\u0004P)\u0002\rAT\u0001\t_JLw-\u001b8bY\"111\u000b\u0016A\u00029\u000bq!\u001e9eCR,G\rK\u0002+\u0003s\u000bqA]3qY\u0006\u001cW\rF\u0003O\u00077\u001ai\u0006\u0003\u0004\u0004P-\u0002\rA\u0014\u0005\u0007\u0007'Z\u0003\u0019\u0001()\u0007-\nI,\u0001\u0006hKR\fE\u000e\u001c+bON$Ba!\u001a\u0004lA1!1LB4\u00033KAa!\u001b\u0003^\t\u00191+\u001a;\t\u000f\r5D\u00061\u0001\u0003n\u0005YA.[7ji:+XNY3sQ\ra\u00131\u0016\u0015\u0004Y\u0005e\u0016AC4fiJ+G.Z1tKR)aja\u001e\u0004\b\"9!1Q\u0017A\u0002\re\u0004\u0003BB>\u0007\u0003sAA!;\u0004~%\u00191q\u00105\u0002\t\rK\u0017\nZ\u0005\u0005\u0007\u0007\u001b)I\u0001\u0003DS&#'bAB@Q\"9\u0011Q_\u0017A\u0002\u0005]\u0018AI2iK\u000e\\\u0017j\u001d(piJ+g-\u001a:f]\u000e,GMQ=EKB,g\u000eZ3oG&,7\u000f\u0006\u0003\u0003|\r5\u0005bBBH]\u0001\u00071\u0011P\u0001\u0018a2\fg.\u0013;f[&#wJ]%ug\u000eC\u0017\u000e\u001c3sK:\fqBZ5oIN\u001bU\nR1uC\nK\u0018\n\u001a\u000b\u0005\u0007+\u001b\u0019\u000bE\u0003B\u0005C\u001c9\n\u0005\u0003\u0004\u001a\u000e}UBABN\u0015\u0011\u0019iJ!\u0019\u0002\t1\fgnZ\u0005\u0005\u0007C\u001bYJA\u0004J]R,w-\u001a:\t\u000f\u0005]u\u00061\u0001\u0002\u001a\"\u001aq&a+)\u0007=\nI,A\u000bgS:$wJ^3sIV,'+\u001a7fCN,\u0017\nZ:\u0015\u0005\t=\u0001f\u0001\u0019\u0002,\"\u001a\u0001'!/\u0002\u001d\u001d,GOU3mK\u0006\u001cXMS:p]R!\u0011\u0011TB[\u0011\u001d\u0011\u0019)\ra\u0001\u00033C3!MAVQ\r\t\u0014\u0011X\u0001\u001bO\u0016$(+\u001a7fCN,7oV5uQ>,HoQ8n[\u0016tGo\u001d\u000b\u0005\u0007\u007f\u001b\u0019\rE\u0003\u0003\u0012\r\u0005g*\u0003\u0003\u0003$\n}\u0001bBBce\u0001\u00071qY\u0001\u000be\u0016dW-Y:f\u0013\u0012\u001c\bC\u0002B\t\u0007\u0003\fI\nK\u00023\u0003WC3AMA]Q\r\u00011q\u001a\t\u0005\u0003[\u001b\t.\u0003\u0003\u0004T\u0006=&aD%t)J\fgn]1di&|g.\u00197")
public class SqlReleaseRepository
implements ReleaseRepository,
InterceptedRepository<Release>,
Logging,
DeserializationSupport,
ConfigurationReferencesSupport,
SqlReleaseRepositoryHelper {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final DependencyPersistence dependencyPersistence;
    private final CommentPersistence commentPersistence;
    private final TeamRepository teamRepository;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect sqlDialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Release>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void replaceTasks(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTasks$(this, original, updated);
    }

    @Override
    public void replaceReleaseExtensions(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseExtensions$(this, original, updated);
    }

    @Override
    public void replaceReleaseTeams(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseTeams$(this, original, updated);
    }

    @Override
    public void updateCommentsOnTasks(Task originalTask, Task updatedTask) {
        SqlReleaseRepositoryHelper.updateCommentsOnTasks$(this, originalTask, updatedTask);
    }

    @Override
    public void insertDependency(Integer gateTaskUid, Dependency dependency) {
        SqlReleaseRepositoryHelper.insertDependency$(this, gateTaskUid, dependency);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Release> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseRepository sqlReleaseRepository = this;
        synchronized (sqlReleaseRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Release>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Release>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public scala.collection.immutable.Seq<String> findIdsByStatus(ReleaseStatus ... statuses) {
        return this.findIdsByStatus((scala.collection.immutable.Seq<ReleaseStatus>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])statuses));
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public CommentPersistence commentPersistence() {
        return this.commentPersistence;
    }

    public TeamRepository teamRepository() {
        return this.teamRepository;
    }

    public ReleaseExtensionsRepository releaseExtensionsRepository() {
        return this.releaseExtensionsRepository;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        return this.releasePersistence.existsRelease(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id)));
    }

    @Timed
    public Release create(Release release, ReleaseCreationSource releaseCreationSource) {
        if (this.releasePersistence.existsRelease(release.getId())) {
            throw new ItemAlreadyExistsException("A release with ID [%s] already exists", new Object[]{release.getId()});
        }
        this.interceptCreate((ConfigurationItem)release);
        this.releasePersistence.insert(release);
        CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
            SqlReleaseRepository.$anonfun$create$1(this, release, task);
            return BoxedUnit.UNIT;
        });
        release.getExtensions().forEach(extension -> this.releaseExtensionsRepository().create(extension));
        this.updateConfigurationRefs((CiWithUid)release);
        this.facetRepositoryDispatcher.liveRepository().createFromTasks(CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq(), this.facetRepositoryDispatcher.liveRepository().createFromTasks$default$2());
        return release;
    }

    @Timed
    public Release findById(String id) {
        return this.getRelease(id, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public Release findById(String id, ResolveOptions resolveOptions) {
        return this.getRelease(id, resolveOptions);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findIdsByStatus(scala.collection.immutable.Seq<ReleaseStatus> statuses) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses(statuses).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSeq();
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withCalendarToken(calendarToken).build();
        scala.collection.immutable.Seq<ReleaseRow> releases = this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams);
        return (Release)releases.headOption().map((Function1 & Serializable)x$1 -> this.deserializeRelease((ReleaseRow)x$1, new ResolveOptionsBuilder().withEverything().build())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findArchivableReleaseIds(Date date, int pageSize) {
        ReleasesSqlBuilder qual$1 = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED})))).withEndDateBefore(date).withPage(new Page(0L, (long)pageSize, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4()));
        boolean x$1 = qual$1.withPreArchived$default$1();
        Tuple2 sqlWithParams = qual$1.withPreArchived(x$1).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSeq();
    }

    @Timed
    public void setPreArchived(String releaseId, boolean preArchived) {
        this.releasePersistence.setPreArchived(releaseId, preArchived);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<Release> findPreArchivableReleases(int page, int pageSize) {
        scala.collection.immutable.Seq inactive = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED}));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)inactive).withPreArchived(false).limitAndOffset(pageSize, page * pageSize).build();
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)x$2 -> this.tryDeserializeRelease((ReleaseRow)x$2, new ResolveOptionsBuilder().withEverything().build()))).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isTutorial()))).map((Function1 & Serializable)release -> this.releaseExtensionsRepository().decorate(release))).map((Function1 & Serializable)release -> this.commentPersistence().decorate((Release)release));
    }

    @Timed
    public java.util.List<Release> search(ReleaseSearchByParams searchParams) {
        ReleaseSearchByParams releaseSearchByParams = searchParams;
        if (releaseSearchByParams == null) {
            throw new MatchError((Object)releaseSearchByParams);
        }
        Page page = releaseSearchByParams.page();
        Either folderId2 = releaseSearchByParams.folderId();
        ReleaseStatus[] statuses = releaseSearchByParams.statuses();
        String title = releaseSearchByParams.title();
        String rootReleaseId = releaseSearchByParams.rootReleaseId();
        boolean autoStart = releaseSearchByParams.autoStart();
        ReleasesSqlBuilder base = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withTitle(title).withRootReleaseId(rootReleaseId).withPage(page);
        ReleasesSqlBuilder sqlBuilder = folderId2 == null ? base : (ReleasesSqlBuilder)folderId2.fold((Function1 & Serializable)folderId -> base.withFolder((String)folderId), (Function1 & Serializable)ancestorId -> base.withAncestor((String)ancestorId));
        Object object = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])statuses)) ? sqlBuilder.withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)statuses)) : BoxedUnit.UNIT;
        Object object2 = autoStart ? sqlBuilder.withAutoStart() : BoxedUnit.UNIT;
        java.util.List list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlBuilder.build()).flatMap((Function1 & Serializable)x$4 -> this.tryDeserializeRelease((ReleaseRow)x$4, new ResolveOptionsBuilder().withEverything().build()))).map((Function1 & Serializable)release -> this.releaseExtensionsRepository().decorate(release))).map((Function1 & Serializable)release -> this.commentPersistence().decorate((Release)release))).asJava();
        return list;
    }

    @Timed
    public void delete(String id) {
        this.checkIsNotReferencedByDependencies(id);
        this.releasePersistence.findUidByReleaseId(id).foreach((Function1 & Serializable)uid -> {
            this.deleteReleaseReferences(id, uid);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.deleteById(id);
    }

    private void deleteReleaseReferences(String id, int releaseUid) {
        this.dependencyPersistence().deleteByReleaseUid(Predef$.MODULE$.int2Integer(releaseUid));
        scala.collection.immutable.Seq<Integer> taskCiUids = this.taskPersistence().findTaskCiUidsByReleaseCiUid(Predef$.MODULE$.int2Integer(releaseUid));
        this.dependencyPersistence().deleteByTaskUids(taskCiUids);
        this.commentPersistence().deleteByRelease(Predef$.MODULE$.int2Integer(releaseUid), taskCiUids);
        this.taskPersistence().deleteTasksByReleaseUid(releaseUid);
        this.teamRepository().deleteTeamsFromPlatform(new SecuredCi(id, releaseUid));
        this.releaseExtensionsRepository().deleteAll(id);
        this.deleteConfigurationRefs(Predef$.MODULE$.int2Integer(releaseUid));
        this.interceptDelete(id);
    }

    @Timed
    public void deleteWithUid(String id, int releaseUid) {
        this.deleteReleaseReferences(id, releaseUid);
        this.releasePersistence.deleteById(id);
    }

    @Timed
    public void move(String originalId, String newId) {
        this.releasePersistence.move(originalId, newId);
    }

    public Option<Integer> getUid(String id) {
        return this.releasePersistence.findUidByReleaseId(id);
    }

    @Timed
    public ReleaseStatus getStatus(String id) {
        String status = (String)this.releasePersistence.findReleaseStatus(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return status == null ? null : ReleaseStatus.valueOf((String)status.toUpperCase());
    }

    @Timed
    public scala.collection.immutable.Seq<ReleaseStatus> getStatuses(scala.collection.immutable.Seq<String> ids) {
        return ids.isEmpty() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$) : (scala.collection.immutable.Seq)this.releasePersistence.findReleaseStatuses(ids).map((Function1 & Serializable)status -> ReleaseStatus.valueOf((String)status.toUpperCase()));
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<Object> getRiskScores(scala.collection.immutable.Seq<String> ids) {
        return this.releasePersistence.findReleaseRiskScores(ids);
    }

    @Timed
    public void setRiskScores(String releaseId, int score, int totalScore) {
        this.releasePersistence.updateReleaseRiskScores(releaseId, score, totalScore);
    }

    @Timed
    @IsReadOnly
    public boolean isTemplate(String releaseId) {
        return ReleaseStatus.TEMPLATE.equals(this.getStatus(releaseId));
    }

    @Timed
    @IsReadOnly
    public String getTitle(String id) {
        return (String)this.releasePersistence.findReleaseTitle(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release [%s] not found", new Object[]{id});
        });
    }

    @Timed
    public Release update(Release release) {
        return this.update(null, release);
    }

    @Timed
    public Release update(Release original, Release updated) {
        Option originalReleaseOpt = Option$.MODULE$.apply((Object)original);
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        originalReleaseOpt.foreach((Function1 & Serializable)rel -> {
            SqlReleaseRepository.$anonfun$update$1(this, updated, rel);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    public Release replace(Release original, Release updated) {
        if (Ids.isFolderId((String)original.getId())) {
            updated.setTeams(Collections.emptyList());
        }
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            this.replaceTasks(original, updated);
            this.replaceReleaseExtensions(original, updated);
            this.replaceReleaseTeams(original, updated);
        }
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.releasePersistence.findAllTags(limitNumber)).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private Release getRelease(String releaseId, ResolveOptions resolveOptions) {
        void var3_3;
        BoxedUnit boxedUnit;
        Release release = (Release)this.repositoryAdapter().read(releaseId, resolveOptions);
        if (release == null) {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        }
        if (resolveOptions.hasDecorators()) {
            this.releaseExtensionsRepository().decorate(release);
            boxedUnit = this.commentPersistence().decorate(release);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        scala.collection.immutable.Seq externalIncomingDependencies = (scala.collection.immutable.Seq)((IterableOps)this.dependencyPersistence().findByPartialTargetIds((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{planItemIdOrItsChildren}))), (Option<scala.collection.immutable.Set<String>>)None$.MODULE$).map((Function1 & Serializable)x$6 -> DependencyRow$.MODULE$.DependencyRowOps((DependencyRow)x$6).fullDependencyId())).filterNot((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(planItemIdOrItsChildren)))));
        if (externalIncomingDependencies.nonEmpty()) {
            throw new ItemInUseException(new StringBuilder(0).append(new StringBuilder(68).append("Cannot delete [").append(planItemIdOrItsChildren).append("] because it or one of its children is referenced by ").toString()).append(new StringBuilder(28).append("one or more dependencies: [").append(externalIncomingDependencies.mkString(", ")).append("]").toString()).toString(), new Object[0]);
        }
    }

    @Timed
    @IsReadOnly
    public Option<Integer> findSCMDataById(String id) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(49).append("Finding scm data for template or release with id ").append(id).toString());
        return this.releasePersistence.findSCMDataById(id).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1));
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findOverdueReleaseIds() {
        return this.releasePersistence.findOverdueReleaseIds();
    }

    @Timed
    @IsReadOnly
    public String getReleaseJson(String releaseId) {
        return (String)this.releasePersistence.findByReleaseId(releaseId).map((Function1 & Serializable)x$8 -> x$8.json()).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        });
    }

    @Timed
    @IsReadOnly
    public List<Release> getReleasesWithoutComments(List<String> releaseIds) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withReleaseIds((scala.collection.immutable.Seq<String>)releaseIds).build();
        scala.collection.immutable.Seq releases = (scala.collection.immutable.Seq)((IterableOps)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)x$9 -> this.tryDeserializeRelease((ReleaseRow)x$9, ResolveOptions$.MODULE$.DEPENDENCIES()))).map((Function1 & Serializable)release -> this.releaseExtensionsRepository().decorate(release));
        return ((IterableOnceOps)releases.sortBy((Function1 & Serializable)r -> BoxesRunTime.boxToInteger((int)releaseIds.indexOf((Object)Ids.getName((String)r.getId()))), (Ordering)Ordering.Int$.MODULE$)).toList();
    }

    public static final /* synthetic */ boolean $anonfun$create$2(SqlReleaseRepository $this, Integer taskUid$1, Comment comment) {
        return $this.commentPersistence().create(taskUid$1, CommentPersistence$CommentRow$.MODULE$.fromComment(comment));
    }

    public static final /* synthetic */ void $anonfun$create$1(SqlReleaseRepository $this, Release release$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(release$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)comment -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$create$2($this, taskUid, comment)));
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$3(SqlReleaseRepository $this, Integer taskUid$2, Comment c) {
        return $this.commentPersistence().create(taskUid$2, CommentPersistence$CommentRow$.MODULE$.fromComment(c));
    }

    public static final /* synthetic */ void $anonfun$update$2(SqlReleaseRepository $this, Release updated$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(updated$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$3($this, taskUid, c)));
        ((IterableOnceOps)syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isArchived()))).foreach((Function1 & Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlReleaseRepository $this, Release updated$1, Release rel) {
        Diff$.MODULE$.apply((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(rel.getAllTasks()).asScala(), (Iterable)CollectionConverters$.MODULE$.ListHasAsScala(updated$1.getAllTasks()).asScala()).newValues().foreach((Function1 & Serializable)task -> {
            SqlReleaseRepository.$anonfun$update$2($this, updated$1, task);
            return BoxedUnit.UNIT;
        });
    }

    public SqlReleaseRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, DependencyPersistence dependencyPersistence, CommentPersistence commentPersistence, TeamRepository teamRepository, ReleaseExtensionsRepository releaseExtensionsRepository, ConfigurationReferencePersistence configurationPersistence, SqlRepositoryAdapter repositoryAdapter, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect sqlDialect) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.commentPersistence = commentPersistence;
        this.teamRepository = teamRepository;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.configurationPersistence = configurationPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.sqlDialect = sqlDialect;
        InterceptedRepository.$init$((InterceptedRepository)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        SqlReleaseRepositoryHelper.$init$(this);
    }
}

